\name{plot.varbvs}
\alias{plot.varbvs}
\title{Summarize variable selection results in a single plot.}
\description{
Generate a single plot that summarizes the results of fitting the
Bayesian variable selection model to the data. When the variables are
genetic markers, the groups are chromosomes, and the posterior
probabilities are plotted on the vertical axis (typically on the
logarithmic scale), the figure resembles a "Manhattan plot" typically
used to summarize the results of a genome-wide association study or
quantitative trait locus (QTL) mapping study.
}
\usage{
  \method{plot}{varbvs}(x, score, groups, vars = NULL, var.labels,
  draw.threshold = NA, gap = 0,col = "midnightblue", pch = 20,
  scales = NULL, xlab = "", ylab = "",
  abline.args = list(lty = "dotted",col = "orangered"),
  vars.xyplot.args = list(pch = 20,col = "magenta"),
  vars.ltext.args = list(col = "black",pos = 4,cex = 0.5), ...)
}
\arguments{
  
  \item{x}{Output of function \code{\link{varbvs}}.}

  \item{score}{Value to plot on vertical axis. Must be a numeric vector
  with one entry for each variable. If missing, the posterior inclusion
  probability for each variable is plotted in the vertical axis, in
  which this probability is averaged over hyperparameter settings,
  treating \code{x$logw} as (unnormalized) log-marginal
  probabilities. As alternative, set \code{score} to the posterior
  inclusion probabilities that ignore correlations, using
  \code{\link{varbvsindep}}.}

  \item{groups}{Group the variables in the plot according to this
  argument. This must be a vector with one entry for each variable. If
  missing, all variables are treated as a single group. This is useful
  for grouping the genetic markers by chromosome in a genome-wide
  association study.}

  \item{vars}{Indices (type \code{integer}) or names (type
  \code{character}) of variables to highlight and label. By default,
  \code{vars = NULL}, meaning no variables are highlighted.}

  \item{var.labels}{Labels to accompany the highlighted variables
  only. If missing, labels are retrieved from \code{x}. If
  \code{var.labels = NULL}, no labels are plotted.}

  \item{draw.threshold}{Plot a horizontal line at this location on the
  vertical axis.}

  \item{gap}{Amount of space to leave between each group of variables in
  the plot.}

  \item{col}{Argument passed to \code{xyplot} specifying color of points.}

  \item{pch}{Argument passed to \code{xyplot} specifying symbol type.}

  \item{scales}{Argument passed to \code{xyplot} specifying how x- and
  y-axes are drawn.}
  
  \item{xlab}{Argument passed to \code{xyplot} specifying horizontal
  axis title.}

  \item{ylab}{Argument passed to \code{xyplot} specifying 
  vertical axis title.}

  \item{abline.args}{Additional arguments passed to \code{panel.abline}
  specifying how to draw the horizontal line at the location specified
  by \code{draw.threshold}.}

  \item{vars.xyplot.args}{Additional arguments passed to \code{xyplot}
  for drawing the highlighted variables.}

  \item{vars.ltext.args}{Additional arguments passed to \code{ltext} for
  specifying how the labels of the highlighted variables are drawn in
  the plot.}

  \item{...}{Additional arguments passed to \code{xyplot} for drawing
    the un-highlighted variables.}
}
\details{
  Note that \code{plot.varbvs} uses function \code{xyplot} from the
  \code{lattice} package, and \code{as.layer} from the
  \code{latticeExtra} package. 
}  
\value{
  An object of class \code{"trellis"} generated by functions
  \code{xyplot} and \code{as.layer}.
}
\references{P. Carbonetto and M. Stephens (2012). Scalable variational
inference for Bayesian variable selection in regression, and its
accuracy in genetic association studies. \emph{Bayesian Analysis}
\bold{7}, 73--108.}
\author{Peter Carbonetto \email{peter.carbonetto@gmail.com}}
\seealso{\code{\link[lattice]{xyplot}}, \code{\link[lattice]{ltext}},
  \code{\link[lattice]{panel.abline}}, \code{\link{varbvs}},
  \code{\link{summary.varbvs}}, \code{\link{varbvsindep}}
}
