% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpers.R
\name{Variability_Measures}
\alias{Variability_Measures}
\alias{by_id}
\alias{rmssd}
\alias{rmssd_id}
\alias{rolling_diff}
\alias{rolling_diff_id}
\alias{sd_id}
\title{Variability Measures}
\usage{
by_id(x, ID, fun, long = TRUE, ...)

sd_id(x, ID, long = TRUE)

rmssd(x)

rmssd_id(x, ID, long = TRUE)

rolling_diff(x, window = 4)

rolling_diff_id(x, ID, long = TRUE, window = 4)
}
\arguments{
\item{x}{A data vector to operate on.  Should be a numeric or
integer vector, or coercible to such (e.g., logical).}

\item{ID}{an ID variable indicating how to split up the \code{x}
vector.  Should be the same length as \code{x}.}

\item{fun}{The function to calculate by ID}

\item{long}{A logical indicating whether to return results in
\dQuote{long} form (the default) or wide (if \code{FALSE}).}

\item{window}{An integer indicating the size of the rolling window.
Must be at least the length of \code{x}.}

\item{\dots}{Additional arguments passed on to \code{fun}}
}
\value{
\code{by_id} - A vector the same length as \code{x}
  if \code{long=TRUE}, or the length of unique \code{ID}s if
  \code{long=FALSE}.

\code{sd_id} - A vector of the standard deviations by ID

\code{rmssd} - The RMSSD for the data.

\code{rmssd_id} - A vector of the RMSSDs by ID

\code{rolling_diff} - The average of the rolling differences between maximum and minimum.

\code{rolling_diff_id} - A vector of the average rolling differences by ID
}
\description{
Variability Measures

\code{by_id} - Internal function to allow a simple statistic (e.g., SD)
to be calculated individually by an ID variable and returned
either as per ID (i.e., wide form) or for every observation of an
ID (i.e., long form).

\code{sd_id} - Calculates the standard deviation of observations by \code{ID}.

\code{rmssd} - Calculates the root mean square of successive differences (RMSSD).
  Note that missing values are removed.

\code{rmssd_id} - Calculates the RMSSD by ID.

\code{rolling_diff} - Calculates the average rolling difference of the data.
  Within each window, the difference between the maximum and minimum value is
  computed and these are averaged across all windows.  The equation is:
\deqn{\frac{\sum_{t = 1}^{N - k} max(x_{t}, \ldots, x_{t + k}) - min(x_{t}, \ldots, x_{t + k})}{N - k}}

\code{rolling_diff_id} - Calculates the average rolling difference by ID
}
\note{
These are a set of functions designed to calculate various
measures of variability either on a single data vector, or
calculate them by an ID.
}
\examples{
sd_id(mtcars$mpg, mtcars$cyl, long=TRUE)
sd_id(mtcars$mpg, mtcars$cyl, long=FALSE)
rmssd(1:4)
rmssd(c(1, 3, 2, 4))
rmssd_id(mtcars$mpg, mtcars$cyl)
rmssd_id(mtcars$mpg, mtcars$cyl, long=FALSE)
rolling_diff(1:7, window = 4)
rolling_diff(c(1, 4, 3, 4, 5))
rolling_diff_id(mtcars$mpg, mtcars$cyl, window = 3)
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{utilities}

