% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dina.R
\name{dina_data_gen}
\alias{dina_data_gen}
\title{the artificial data generation for the DINA model based on the given Q-matrix}
\usage{
dina_data_gen(Q, I, cor = 0.1, s = 0.2, g = 0.2, seed = 17)
}
\arguments{
\item{Q}{the J by K binary matrix}

\item{I}{the number of assumed respondents}

\item{cor}{the true value of the correlation among attributes (default: 0.1)}

\item{s}{the true value of the slip parameter (default: 0.2)}

\item{g}{the true value of the guessing parameter (default: 0.2)}

\item{seed}{the seed value used for random number generation (default: 17)}
}
\value{
A list including:
\describe{
  \item{X}{the generated artificial item response data}
  \item{att_pat}{the generated true vale of the attribute mastery pattern}
}
}
\description{
\code{dina_data_gen()} returns the artificially generated item response data for the DINA model
}
\examples{
# load Q-matrix
Q = sim_Q_J80K5
sim_data = dina_data_gen(Q=Q,I=200)
}
\references{
Oka, M., & Okada, K. (2023). Scalable Bayesian Approach for the Dina
  Q-Matrix Estimation Combining Stochastic Optimization and Variational Inference.
  \emph{Psychometrika}, 88, 302–331. \doi{10.1007/s11336-022-09884-4}
}
