\name{stability}

\alias{stability}
\alias{stability.default}
\alias{stability.varest}
\alias{print.varstabil}

\title{Structural stability of a VAR(p)}

\encoding{latin1}

\description{
  Computes an empirical fluctuation process according to a specified
  method from the generalised fluctuation test framework. The test
  utilises the function \command{efp()} and its methods from
  package \sQuote{\code{strucchange}}.
}

\usage{
\method{stability}{default}(x, type = c("OLS-CUSUM", "Rec-CUSUM",
"Rec-MOSUM", "OLS-MOSUM", "RE", "ME", "Score-CUSUM", "Score-MOSUM",
"fluctuation"), h = 0.15, dynamic = FALSE, rescale = TRUE, ...)
\method{stability}{varest}(x, type = c("OLS-CUSUM", "Rec-CUSUM",
"Rec-MOSUM", "OLS-MOSUM", "RE", "ME", "Score-CUSUM", "Score-MOSUM",
"fluctuation"), h = 0.15, dynamic = FALSE, rescale = TRUE, ...)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}.} 
  \item{type}{Specifies which type of fluctuation process will be
    computed, the default is \sQuote{\code{OLS-CUSUM}}. For details see:
    \code{\link[strucchange]{efp}}.}
  \item{h}{A numeric from interval (0,1) sepcifying the
    bandwidth. Determins the size of the data window relative to sample
    size (for \sQuote{\code{MOSUM}} and \sQuote{\code{ME}} processes only).}
  \item{dynamic}{Logical. If \sQuote{\code{TRUE}} the lagged
    observations are included as a regressor.}  
  \item{rescale}{Logical. If \sQuote{\code{TRUE}} the estimates will be
    standardized by the regressor matrix of the corresponding subsample;
    if \sQuote{\code{FALSE}} the whole regressor matrix will be
    used. (only if \sQuote{\code{type}} is either \sQuote{\code{RE}} or
    \sQuote{\code{E}}).}
  \item{...}{Ellipsis, is passed to \code{strucchange::sctest()}, as default.}
}
\details{
  For details, please refer to documentation \code{\link[strucchange]{efp}}.
}

\value{
  A list with class attribute \sQuote{\code{varstabil}} holding the
  following elements:\cr

  \item{stability}{A list with objects of class \sQuote{\code{efp}};
    length is equal to the dimension of the VAR.}
  \item{names}{Character vector containing the names of the endogenous
    variables.} 
  \item{K}{An integer of the VAR dimension.}
}

\author{Bernhard Pfaff}

\references{
   Zeileis, A., F. Leisch, K. Hornik and C. Kleiber (2002), strucchange:
   An R Package for Testing for Structural Change in Linear Regression
   Models, \emph{Journal of Statistical Software}, \bold{7(2)}: 1-38,
   \url{http://www.jstatsoft.org/v07/i02/}

   and see the references provided in the reference section of
   \code{\link[strucchange]{efp}}, too.   
}

\seealso{
  \code{\link{VAR}}, \code{\link{plot}}, \code{\link[strucchange]{efp}} 
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
var.2c.stabil <- stability(var.2c, type = "OLS-CUSUM")
var.2c.stabil
\dontrun{
plot(var.2c.stabil)
}
}

\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive model}
\concept{Structural Stability}
\concept{efp}
\concept{Empirical Fluctuation Process}


