\name{irf}

\alias{irf}

\alias{print.varirf}

\alias{irf.varest}

\alias{irf.svarest}

\alias{irf.svecest}

\alias{irf.vec2var}

\title{Impulse response function}

\encoding{latin1}

\description{
  Computes the impulse response coefficients of a VAR(p) (or transformed
  VECM to VAR(p)) or a SVAR for \code{n.ahead} steps. 
}

\usage{
\method{irf}{varest}(x, impulse = NULL, response = NULL, n.ahead = 10,
ortho = TRUE, cumulative = FALSE, boot = TRUE, ci = 0.95,
runs = 100, seed = NULL, ...)
\method{irf}{svarest}(x, impulse = NULL, response = NULL, n.ahead = 10,
ortho = TRUE, cumulative = FALSE, boot = TRUE, ci = 0.95,
runs = 100, seed = NULL, ...)
\method{irf}{vec2var}(x, impulse = NULL, response = NULL, n.ahead = 10,
ortho = TRUE, cumulative = FALSE, boot = TRUE, ci = 0.95,
runs = 100, seed = NULL, ...)
\method{irf}{svecest}(x, impulse = NULL, response = NULL, n.ahead = 10,
ortho = TRUE, cumulative = FALSE, boot = TRUE, ci = 0.95,
runs = 100, seed = NULL, ...)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}, or object of class \sQuote{\code{svarest}}; generated by
    \command{SVAR()}, or object of class \sQuote{\code{vec2var}}; generated by
    \command{vec2var()}, or object of class \sQuote{\code{svecest}};
    generated by \command{SVEC()}.}  
  \item{impulse}{A character vector of the impulses, default is all
    variables.}  
  \item{response}{A character vector of the responses, default is all
    variables.}  
  \item{n.ahead}{Integer specifying the steps.}
  \item{ortho}{Logical, if \code{TRUE} (the default) the orthogonalised impulse
    response coefficients are computed (only for objects of class
    \sQuote{\code{varest}}).}    
  \item{cumulative}{Logical, if \code{TRUE} the cumulated
    impulse response coefficients are computed. The default value is false.}  
  \item{boot}{Logical, if \code{TRUE} (the default) bootstrapped error
    bands for the imuplse response coefficients are computed.}  
  \item{ci}{Numeric, the confidence interval for the bootstrapped errors
    bands.}
  \item{runs}{An integer, specifying the runs for the bootstrap.}
  \item{seed}{An integer, specifying the seed for the \code{rng} of the
    bootstrap.}
  \item{...}{Currently not used.}
}

\details{
  The impulse response coefficients of a VAR(p) for \code{n.ahead} steps
  are computed by utilising either the function \command{Phi()} or
  \command{Psi()}. If \code{boot = TRUE} (the default), confidence
  bands for a given width specified by \code{ci} are derived from
  \code{runs} bootstrap. Hereby, it is at the users leisure to set a
  \code{seed} for the random number generator.\cr
  The standard percentile interval is defined as:
  \deqn{
    CI_s = [s_{\alpha/2}^*, s_{1 - \alpha/2}^*] \quad ,
  }
  with \eqn{s_{\alpha/2}^*} and \eqn{s_{1 - \alpha/2}^*} are the
  \eqn{\alpha/2} and \eqn{1 - \alpha/2} quantiles of the bootstrap
  distribution of \eqn{\Psi^*} or \eqn{\Phi^*} depending whether
  \code{ortho = TRUE}. In case \code{cumulative = TRUE}, the confidence
  bands are calculated from the cumulated impulse response
  coefficients. 
}
\value{
  A list of class \sQuote{\code{varirf}} with the following elements is
  returned:\cr
  
  \item{irf}{A list with matrices for each of the impulse variables
    containing the impulse response coefficients.}
  \item{Lower}{If \code{boot = TRUE}, a list with matrices for each of
    the impulse variables containing the lower bands.}
  \item{Upper}{If \code{boot = TRUE}, a list with matrices for each of
    the impulse variables containing the upper bands.}
  \item{response}{Character vector holding the names of the response
    variables.}  
  \item{impulse}{Character vector holding the names of the impulse  variables.}
  \item{ortho}{Logical, if \code{TRUE}, orthogonalised impulse reponses
    have been computed.}
  \item{cumulative}{Logical, if \code{TRUE}, cumulated impulse reponses
    have been computed.}
  \item{runs}{An integer, specifying the number of bootstrap runs.}
  \item{ci}{Numeric, defining the confidence level.}
  \item{boot}{Logical, if \code{TRUE} bootstrapped error bands have been
    computed.}
  \item{model}{Character, containing \sQuote{\code{class(x)}}.}
}

\author{Bernhard Pfaff}

\references{
  Efron, B. and R. J. Tibshirani (1993), \emph{An Introduction to the
    Bootstrap}, Chapman and Hall, New York. 
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York. 
}

\seealso{
  \code{\link{VAR}}, \code{\link{SVAR}}, \code{\link{vec2var}},
  \code{\link{SVEC}}, \code{\link{Phi}}, \code{\link{Psi}}, \code{\link{plot}} 
}

\examples{
data(Canada)
## For VAR
var.2c <- VAR(Canada, p = 2, type = "const")
irf(var.2c, impulse = "e", response = c("prod", "rw", "U"), boot =
FALSE)
## For SVAR
amat <- diag(4)
diag(amat) <- NA
svar.a <- SVAR(var.2c, estmethod = "direct", Amat = amat)
irf(svar.a, impulse = "e", response = c("prod", "rw", "U"), boot =
FALSE)
}


\keyword{regression}
\concept{VAR}
\concept{SVAR}
\concept{Vector autoregressive model}
\concept{Structural vector autoregressive model}
\concept{irf}
\concept{impulse response function}
\concept{VECM}

