% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{VariableDef-class}
\alias{VariableDef-class}
\title{Class VariableDef}
\description{
The \code{VariableDef} class is used to store properly the definition of the variable.
}
\section{Slots}{

\describe{
\item{\code{varlabel}}{A length-one character vector. Should be with a max of 40 letters. All characters are allowed. Will be used to varlabel properly the plots and tables in output.}

\item{\code{description}}{A length-one character vector. Description of the variable.}

\item{\code{rname}}{A length-one character vector. Should be with a max of 16 letters. It's the name of the variable used in R. It could only use [a-z], [0-9] and "_" and must start with [a-z].}

\item{\code{comment}}{A length-one character vector with a max of 1000 letters. It's a commentary that will appear when describing each variable and give some advices to the statistician to how to analyze this variable.}

\item{\code{type}}{A length-one character vector. Must be one of the following : numeric, integer, factor, ordered, character, date or not_used. It's used to dispatch the script blocs regarding the type of the variable.}

\item{\code{unit}}{A length-one character vector of max size 20. Should be the unit of a variable which will be showed in some graphs or the format of a date (by default \code{\%d/\%m/\%Y}).}

\item{\code{levels}}{A character vector. Only used if type is factor or ordered. Describe the levels used. The same levels must be in the database, otherwise NA will be generated.}

\item{\code{labels}}{A character vector of the same size than levels or empty. If empty, the labels will be the levels.}
}}
\author{
Joris Muller
}
\seealso{
The constructor is \link{vardef}. For several variables, see \code{\link{DatabaseDef-class}}
}
\keyword{classes}

