% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVC_selection.R
\name{SVC_selection}
\alias{SVC_selection}
\title{SVC Model Selection}
\usage{
SVC_selection(obj.fun, mle.par, control, ...)
}
\arguments{
\item{obj.fun}{(\code{SVC_obj_fun}) \cr
Function of class \code{SVC_obj_fun}. This is the output of
\code{\link{SVC_mle}} with the \code{\link{SVC_mle_control}} parameter
\code{extract_fun} set to \code{TRUE}. This objective function comprises
of the whole SVC model on which the selection should be applied.}

\item{mle.par}{(\code{numeric(2*q+1)}) \cr
Numeric vector with estimated covariance parameters of unpenalized MLE.}

\item{control}{(\code{list}) \cr
List of control parameters for variable selection. Output of
\code{\link{SVC_selection_control}}.}

\item{...}{Further arguments.}
}
\value{
Returns an object of class \code{SVC_selection}. It contains parameter estimates under PMLE and the optimization as well as choice of the shrinkage parameters.
}
\description{
This function implements the variable selection for
  Gaussian process-based SVC models using a penalized maximum likelihood
  estimation (PMLE, Dambon et al., 2021, <arXiv:2101.01932>).
  It jointly selects the fixed and random effects of GP-based SVC models.
}
\references{
Dambon, J. A., Sigrist, F., Furrer, R. (2021).
   \emph{Joint Variable Selection of both Fixed and Random Effects for
   Gaussian Process-based Spatially Varying Coefficient Models},
   ArXiv Preprint \url{https://arxiv.org/abs/2101.01932}
}
\author{
Jakob Dambon
}
