% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_functions.R
\name{Sigma_y}
\alias{Sigma_y}
\title{Covariance Matrix of GP-based SVC Model}
\usage{
Sigma_y(x, cov_func, outer.W, taper = NULL)
}
\arguments{
\item{x}{(\code{numeric(2q+1)}) \cr Non negative vector containing
the covariance parameters in the following order: \eqn{\rho_1, \sigma_1^2,
..., \rho_q, \sigma_q^2 , \tau^2}. Note that the odd entries, i.e., the
ranges and the nugget variance, have to be greater than 0, otherwise the
covariance matrix is not well-defined (singularities or not-invertible).}

\item{cov_func}{(\code{function}) \cr A covariance function that works on
the pre-defined distance matrix \code{d}. It takes a numeric vector as an
input, the first entry being the range, the second being the variance
(also called partial sill). Usually, it is defined as, e.g.:
\code{function(pars) spam::cov.exp(d, pars)} or any other covariance function
defined for two parameters.}

\item{outer.W}{(\code{list(q)}) \cr A list of length \code{q} containing
the outer products of the random effect covariates in a lower triangular,
(possibly sparse) matrix. If tapering is applied, the list entries, i.e.,
the outer products have to be given as \code{\link[spam]{spam}} objects.}

\item{taper}{(\code{NULL} or \code{spam}) \cr If covariance tapering is
applied, this argument contains the taper matrix, which is a
\code{\link[spam]{spam}} object. Otherwise, it is \code{NULL}.}
}
\value{
Returns a positive-definite covariance matrix y, which is needed in
the MLE. Specifically, a Cholesky Decomposition is applied on the covariance
matrix.
}
\description{
Builds the covariance matrix of \eqn{y} (p. 6, Dambon et al. (2021)
\doi{10.1016/j.spasta.2020.100470}) for a given set of covariance
parameters and other, pre-defined objects (like the outer-products,
covariance function, and, possibly, a taper matrix).
}
\examples{
# locations
locs <- 1:6
# random effects covariates
W <- cbind(rep(1, 6), 5:10)
# distance matrix with and without tapering
d <- as.matrix(dist(locs))
# distance matrix with and without tapering
tap_dist <- 2
d_tap <- spam::nearest.dist(locs, delta = tap_dist)
# call without tapering
(Sy <- varycoef:::Sigma_y(
  x = rep(0.5, 5),
  cov_func = function(x) spam::cov.exp(d, x),
  outer.W = lapply(1:ncol(W), function(k) W[, k] \%o\% W[, k])
))
str(Sy)
# call with tapering
(Sy_tap <- varycoef:::Sigma_y(
  x = rep(0.5, 5),
  cov_func = function(x) spam::cov.exp(d_tap, x),
  outer.W = lapply(1:ncol(W), function(k)
    spam::as.spam((W[, k] \%o\% W[, k]) * (d_tap<=tap_dist))
  ),
  taper = spam::cov.wend1(d_tap, c(tap_dist, 1, 0))
))
str(Sy_tap)
# difference between tapered and untapered covariance matrices
Sy-Sy_tap
}
\references{
Dambon, J. A., Sigrist, F., Furrer, R. (2021)
   \emph{Maximum likelihood estimation of spatially varying coefficient
   models for large data with an application to real estate price prediction},
   Spatial Statistics \doi{10.1016/j.spasta.2020.100470}
}
\author{
Jakob Dambon
}
