% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.meanratio2}
\alias{meta.ave.meanratio2}
\title{Confidence interval for an average mean ratio from 2-group studies}
\usage{
meta.ave.meanratio2(alpha, m1, m2, sd1, sd2, n1, n2, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of sample means for group 1}

\item{m2}{vector of sample means for group 2}

\item{sd1}{vector of sample SDs for group 1}

\item{sd2}{vector of sample SDs for group 2}

\item{n1}{vector of group 1 sample size}

\item{n2}{vector of group 2 sample sizes}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
A matrix.  First row is the overall average estimate.  If bystudy is
TRUE also returns 1 row per study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - the exponentiated estimate (the geometric mean)
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
\item df - degrees of freedom
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
geometric average mean ratio from two or more 2-group studies. A Satterthwaite
adjustment to the degrees of freedom is used to improve the accuracy of the
confidence intervals. Equal variances within or across studies is not assumed.
}
\examples{
m1 <- c(7.4, 6.9)
m2 <- c(6.3, 5.7)
sd1 <- c(1.7, 1.5)
sd2 <- c(2.3, 2.0)
n1 <- c(40, 20)
n2 <- c(40, 20)
meta.ave.meanratio2(.05, m1, m2, sd1, sd2, n1, n2, bystudy = TRUE)

# Should return:
#          Estimate         SE          LL        UL  exp(Estimate)
# Average 0.1759928 0.05738065 0.061437186 0.2905484       1.192429
# Study 1 0.1609304 0.06820167 0.024749712 0.2971110       1.174603
# Study 2 0.1910552 0.09229675 0.002986265 0.3791242       1.210526
#          exp(LL)  exp(UL)       df
# Average 1.063364 1.337161 66.26499
# Study 1 1.025059 1.345965 65.69929
# Study 2 1.002991 1.461004 31.71341


}
\references{
\insertRef{Bonett2020}{vcmeta}
}
