% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.sub.semipart}
\alias{meta.sub.semipart}
\title{Confidence interval for a difference in average semipartial
correlations for two sets of studies}
\usage{
meta.sub.semipart(alpha, n, cor, r2, group)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of sample semi-partial correlations}

\item{r2}{vector of squared multiple correlations for a model that
includes the IV and all control variables}

\item{group}{vector of group indicators:
\itemize{
\item 1 for set A
\item 2 for set B
\item 0 to ignore
}}
}
\value{
Returns a matrix with three rows:
\itemize{
\item Row 1 - Estimate for Set A
\item Row 2 - Estimate for Set B
\item Row 3 - Estimate for difference, Set A - Set B
}

The columns are:
\itemize{
\item Estimate - estimate of average correlation or difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
difference in average semipartial correlations for two sets of
mutually exclusive studies. Each set can have one or more studies.
}
\examples{
n <- c(55, 190, 65, 35)
cor <- c(.40, .65, .60, .45)
r2 <- c(.25, .41, .43, .39)
group <- c(1, 1, 2, 0)	
meta.sub.semipart(.05, n, cor, r2, group)

# Should return:
#                Estimate         SE         LL        UL
# Set A:            0.525 0.05955276  0.3986844 0.6317669
# Set B:            0.600 0.07931155  0.4221127 0.7333949
# Set A - Set B:   -0.075 0.09918091 -0.2587113 0.1324682


}
