% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_misc.R
\name{meta.chitest}
\alias{meta.chitest}
\title{Computes a chi-square test of effect-size homogeneity}
\usage{
meta.chitest(est, se)
}
\arguments{
\item{est}{vector of effect-size estimates}

\item{se}{vector of effect-size standard errors}
}
\value{
Returns a one-row matrix:
\itemize{
\item Q - chi-square test statitic
\item df - degrees of freedom
\item p - p-value
}
}
\description{
Computes a chi-square test of effect size homogeneity and p-value using
effect-size estimates and their standard errors from two or more studies.
This test should not be used to justify the use of a constant coeffient
(fixed-effect) meta-analysis. This test can be used to justify the
estimation of an average effect size in a varying coefficient model.
}
\examples{
est <- c(.297, .324, .281, .149) 
se <- c(.082, .051, .047, .094)
meta.chitest(est, se)

# Should return:
#         Q df         p
#  2.706526  3 0.4391195


}
\references{
\insertRef{Borenstein2009}{vcmeta}
}
