% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.biphi}
\alias{se.biphi}
\title{Computes the standard error for a biserial-phi correlation}
\usage{
se.biphi(f1, f2, n1, n2)
}
\arguments{
\item{f1}{number of participants in group 1 who have the attribute}

\item{f2}{number of participants in group 2 who have the attribute}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated biserial-phi correlation
\item SE - standard error
}
}
\description{
This function can be used to compute an estimate of a biserial-phi
correlation and its standard error using the frequency counts from a 2 x 2
contingency table where one variable is naturally dichotomous and the other
variable is artifically dichotomous. A biserial-phi correlation could be
compatible with a point-biserial correlation in a meta-analysis. The
biserial-phi estimate and the standard error from this function can be used
as input in the \link[vcmeta]{meta.ave.gen} function in a meta-analysis
where a point-biserial correlation has been obtained in some studies and
a biserial-phi correlation has been obtained in other studies.
}
\examples{
se.biphi(34, 22, 50, 50)

# Should return:
#               Estimate        SE 
# Biserial-phi:  0.27539 0.1074594


}
