% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.R, R/type-bare.R
\name{vec_cast}
\alias{vec_cast}
\alias{vec_cast_common}
\alias{vec_cast.logical}
\alias{vec_cast.integer}
\alias{vec_cast.double}
\alias{vec_cast.complex}
\alias{vec_cast.raw}
\alias{vec_cast.character}
\alias{vec_cast.list}
\title{Cast a vector to a specified type}
\usage{
vec_cast(x, to, ..., x_arg = caller_arg(x), to_arg = "", call = caller_env())

vec_cast_common(..., .to = NULL, .arg = "", .call = caller_env())

\method{vec_cast}{logical}(x, to, ...)

\method{vec_cast}{integer}(x, to, ...)

\method{vec_cast}{double}(x, to, ...)

\method{vec_cast}{complex}(x, to, ...)

\method{vec_cast}{raw}(x, to, ...)

\method{vec_cast}{character}(x, to, ...)

\method{vec_cast}{list}(x, to, ...)
}
\arguments{
\item{x}{Vectors to cast.}

\item{to, .to}{Type to cast to. If \code{NULL}, \code{x} will be returned as is.}

\item{...}{For \code{vec_cast_common()}, vectors to cast. For
\code{vec_cast()}, \code{vec_cast_default()}, and \code{vec_restore()}, these
dots are only for future extensions and should be empty.}

\item{x_arg}{Argument names for \code{x} and \code{to}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{to_arg}{Argument names for \code{x} and \code{to}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{call, .call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{.arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}
}
\value{
A vector the same length as \code{x} with the same type as \code{to},
or an error if the cast is not possible. An error is generated if
information is lost when casting between compatible types (i.e. when
there is no 1-to-1 mapping for a specific value).
}
\description{
\code{vec_cast()} provides directional conversions from one type of
vector to another. Along with \code{\link[=vec_ptype2]{vec_ptype2()}}, this generic forms
the foundation of type coercions in vctrs.
}
\section{Implementing coercion methods}{
\itemize{
\item For an overview of how these generics work and their roles in vctrs,
see \code{\link[=theory-faq-coercion]{?theory-faq-coercion}}.
\item For an example of implementing coercion methods for simple vectors,
see \code{\link[=howto-faq-coercion]{?howto-faq-coercion}}.
\item For an example of implementing coercion methods for data frame
subclasses, see
\code{\link[=howto-faq-coercion-data-frame]{?howto-faq-coercion-data-frame}}.
\item For a tutorial about implementing vctrs classes from scratch, see
\code{vignette("s3-vector")}.
}
}

\section{Dependencies of \code{vec_cast_common()}}{

\subsection{vctrs dependencies}{
\itemize{
\item \code{\link[=vec_ptype2]{vec_ptype2()}}
\item \code{\link[=vec_cast]{vec_cast()}}
}
}

\subsection{base dependencies}{

Some functions enable a base-class fallback for
\code{vec_cast_common()}. In that case the inputs are deemed compatible
when they have the same \link[base:typeof]{base type} and inherit from
the same base class.
}
}

\examples{
# x is a double, but no information is lost
vec_cast(1, integer())

# When information is lost the cast fails
try(vec_cast(c(1, 1.5), integer()))
try(vec_cast(c(1, 2), logical()))

# You can suppress this error and get the partial results
allow_lossy_cast(vec_cast(c(1, 1.5), integer()))
allow_lossy_cast(vec_cast(c(1, 2), logical()))

# By default this suppress all lossy cast errors without
# distinction, but you can be specific about what cast is allowed
# by supplying prototypes
allow_lossy_cast(vec_cast(c(1, 1.5), integer()), to_ptype = integer())
try(allow_lossy_cast(vec_cast(c(1, 2), logical()), to_ptype = integer()))

# No sensible coercion is possible so an error is generated
try(vec_cast(1.5, factor("a")))

# Cast to common type
vec_cast_common(factor("a"), factor(c("a", "b")))
}
\seealso{
Call \code{\link[=stop_incompatible_cast]{stop_incompatible_cast()}} when you determine from the
attributes that an input can't be cast to the target type.
}
