% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ts.R
\name{plot_ts}
\alias{plot_ts}
\title{Create a ggplot object with a time series and forecast}
\usage{
plot_ts(
  ts,
  future = NULL,
  prediction = NULL,
  method = NULL,
  lpi = NULL,
  upi = NULL,
  level = NULL,
  sdp = TRUE
)
}
\arguments{
\item{ts}{a time series of class \code{ts}.}

\item{future}{NULL (default) or a time series of class \code{ts} or a vector.
Future values of the time series.}

\item{prediction}{NULL (default) or a time series of class \code{ts} or a
vector. Forecast of the future values of the time series.}

\item{method}{NULL (default) a character string with the name of the method
used to forecast the future values of the time series. This name will
appear in the legend.}

\item{lpi}{NULL (default) or a time series of class \code{ts} or a vector.
Lower limit of a prediction interval for the \code{prediction} parameter.}

\item{upi}{NULL (default) or a time series of class \code{ts} or a vector.
Upper limit of a prediction interval for the \code{prediction} parameter.}

\item{level}{NULL (default) a number in the interval (0, 100) indicating the
level of the prediction interval.}

\item{sdp}{logical. Should data points be shown? (default value \code{TRUE})}
}
\value{
The \code{ggplot} object representing the time series and its forecast.
}
\description{
Create a \code{ggplot} object associated with a time series and, optionally, its
future values, a forecast for its future values and a prediction interval of
the forecast.
}
\details{
If \code{future} or \code{prediction} are vectors then they are supposed to
start after the last data of the time series.
}
\examples{
library(ggplot2)
plot_ts(USAccDeaths) # plot a time series

# plot a time series, not showing data points
plot_ts(USAccDeaths, sdp = FALSE)

# plot a time series, its future values and a prediction
ts <- window(USAccDeaths, end = c(1977, 12))
f <- window(USAccDeaths, start = c(1978, 1))
p <- ts(window(USAccDeaths, start = c(1976, 1), end = c(1976, 12)),
        start = c(1978, 1),
        frequency = 12
)
plot_ts(ts, future = f, prediction = p)

# plot a time series and a prediction
plot_ts(USAccDeaths, prediction = rep(mean(USAccDeaths), 12),
        method = "Mean")

# plot a time series, a prediction and a prediction interval
if (require(forecast)) {
  timeS <- window(USAccDeaths, end = c(1977, 12))
  f <- window(USAccDeaths, start = c(1978, 1))
  ets_fit <- ets(timeS)
  p <- forecast(ets_fit, h = length(f), level = 90)
  plot_ts(timeS, future = f, prediction = p$mean, method = "ES",
          lpi = p$lower, upi = p$upper, level = 90
  )
}
}
