% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPoolsComparisonTable.R
\name{getPoolsComparisionTable}
\alias{getPoolsComparisionTable}
\title{Get Pools Frequency Table}
\usage{
getPoolsComparisionTable(
  pools,
  interval,
  target_disease,
  species_separate = FALSE
)
}
\arguments{
\item{pools}{Pools data retrieved from `getPools()`}

\item{interval}{Calculation interval for comparison table, accepts “collection_date”,“Biweek”,“Week”, and “Month}

\item{target_disease}{The disease to calculate infection rate for–i.e. “WNV”.
Disease acronyms are the accepted input. To see a list of disease acronyms, run `unique(pools$target_acronym)`}

\item{species_separate}{Should the pools comparison be split by species of each pool. Default is FALSE}
}
\value{
Frequency table of for pools data
}
\description{
`getPoolsComparisionTable()` produces a frequency table for positive, negative, and pending pools counts by year and
species. The more years present in the data, the larger the table.
}
\examples{
getPoolsComparisionTable(sample_pools,
                         interval = "Biweek",
                         target_disease = "WNV",
                          species_separate = TRUE)
}
