"anova.ccabyaxis" <-
function (object, ...) 
{
    rnk <- object$CCA$rank
    if (!max(rnk, 0)) 
        stop("Needs a constrained ordination")
    if (is.null(object$terms)) 
        stop("Analysis is only possible for models fitted using formula")
    lc <- object$CCA$u
    newdata <- model.frame(object$terminfo, data = eval(as.list(object$call)$data))
    newdata <- cbind(lc, newdata)
    axnam <- colnames(lc)
    df <- c(rep(1, rnk), object$CA$rank)
    chi <- c(object$CCA$eig, Residual = object$CA$tot.chi)
    Fval <- c(numeric(rnk), NA)
    nperm <- c(numeric(rnk), NA)
    Pval <- c(numeric(rnk), NA)
    out <- data.frame(df, chi, Fval, nperm, Pval)
    sol <- anova(object, first = TRUE, ...)
    out[c(1, rnk + 1), ] <- sol
    seed <- attr(sol, "Random.seed")
    attr(out, "names") <- attr(sol, "names")
    attr(out, "heading") <- attr(sol, "heading")
    attr(out, "Random.seed") <- seed
    bigseed <- get(".Random.seed", envir = .GlobalEnv, inherits = FALSE)
    bigperm <- out$N.Perm[1]
    environment(object$terms) <- environment()
    if (rnk > 1) {
        for (i in 2:rnk) {
            zz <- paste(paste("Condition(", axnam[1:(i - 1)], 
                ")"), collapse = "+")
            fla <- update(formula(object), paste(". ~ . +", zz))
            sol <- update(object, fla, data = newdata)
            assign(".Random.seed", seed, envir = .GlobalEnv)
            out[i, ] <- as.matrix(anova(sol, first = TRUE, ...))[1, 
                ]
            if (out[i, "N.Perm"] > bigperm) {
                bigperm <- out[i, "N.Perm"]
                bigseed <- get(".Random.seed", envir = .GlobalEnv, 
                  inherits = FALSE)
            }
        }
    }
    assign(".Random.seed", bigseed, envir = .GlobalEnv)
    class(out) <- c("anova.cca", "anova", "data.frame")
    out
}

