% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_juice.R
\name{write_juice}
\alias{write_juice}
\alias{write_juice,vegtable,character,formula-method}
\alias{read_juice}
\title{Exporting tables for Juice}
\usage{
write_juice(data, file, formula, ...)

\S4method{write_juice}{vegtable,character,formula}(
  data,
  file,
  formula,
  FUN,
  db_name = "Plot Observations",
  header,
  coords,
  ...
)

read_juice(file, encoding = "LATIN-1", sep = ";", na = "", ...)
}
\arguments{
\item{data}{An object of class \linkS4class{vegtable}.}

\item{file}{Character value indicating the name of output files (without
file extension).}

\item{formula}{A formula passed to \code{\link[=crosstable]{crosstable()}}.}

\item{...}{Further arguments. While \code{write_juice()} passes them to the
function \code{\link[=crosstable]{crosstable()}}, \code{read_juice()} passes those arguments to
\code{\link[=readLines]{readLines()}}.}

\item{FUN}{Funtion passed to \code{\link[=crosstable]{crosstable()}}.}

\item{db_name}{Name for data set displayed in inport wizard.}

\item{header}{Variables of header to be exported.}

\item{coords}{Names of coordinate variables in header of \code{data}.}

\item{encoding}{Argument passed to \code{\link{readLines}}.}

\item{sep}{Separator used to split rows into columns.}

\item{na}{Character used as not available values.}
}
\value{
For \code{read_juice()}, a list with two elements: A data frame of species by
plot (\code{cross_table}), and a data frame with header data (\code{header}).
}
\description{
This function produce txt files as inport formats for \strong{Juice}
(\url{http://www.sci.muni.cz/botany/juice/}).

This function produces two output files to be imported into a \strong{Juice}
file: A vegetation table produced by \code{\link[=crosstable]{crosstable()}} and a header table.
Both tables share the file name plus a suffix (\code{table} for the
vegetation table and \code{header} for the header).

For the import in \strong{Juice}, you may start with the table following in
the menu \verb{File -> Import -> Table -> from Spreadsheet File (e.g. EXCEL Table)} and then follow the wizard. You further import the header table
following in the menu \verb{File -> Import -> Header Data -> From Comma Delimited File}.
Notice that the vegetation is a semi-colon delimited file, while the header
is a comma delimited file.

For a properly import, you may strictly follow the export steps in \strong{Juice}:
\enumerate{
\item In menu \verb{File -> Export -> Table -> to Spreadsheet Format File} and
\item check the option \verb{Export covers in \%}.
}

In the \code{header} (see \strong{Value}), the first column (\code{juice_nr})
corresponds to the plot number assigned by \strong{Juice} at import, while
the column \code{db_nr} is the number originally assigned to the plot (e.g.
\strong{Turboveg} ID).
}
\examples{
## Only first 20 observations
Kenya_veg <- Kenya_veg[1:20,]
\dontrun{
write_juice(Kenya_veg, "SWEA", FUN=mean)
}

## Installed 'Juice' version of 'Wetlands_veg'
Veg <- file.path(path.package("vegtable"), "juice", "Wetlands_juice.txt")
Veg <- read_juice(Veg)

summary(Veg)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
