% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmissionsList.R, R/Evaporative.R, R/ef_emfac.R,
%   R/emis_wrf.R, R/hot_soak.R, R/running_losses.R, R/vein-deprecated.R
\name{vein-deprecated}
\alias{vein-deprecated}
\alias{EmissionsList}
\alias{print.EmissionsList}
\alias{summary.EmissionsList}
\alias{plot.EmissionsList}
\alias{Evaporative}
\alias{print.Evaporative}
\alias{summary.Evaporative}
\alias{plot.Evaporative}
\alias{ef_emfac}
\alias{emis_wrf}
\alias{hot_soak}
\alias{running_losses}
\title{DEPRECATED Construction function for class "EmissionsList"}
\usage{
EmissionsList(x, ...)

Evaporative(x, ...)

ef_emfac(x, ...)

emis_wrf(sdf, nr = 1, dmyhm, tz, crs = 4326, islist)

hot_soak(x, carb, p, eshotc, eswarmc, eshotfi)

running_losses(x, erhotfi, lkm, carb, p, erhotc, erwarmc)
}
\arguments{
\item{x}{Object with class "numeric"}

\item{...}{ignored}

\item{sdf}{Gridded emissions, which can be a SpatialPolygonsDataFrame, or a list
of SpatialPolygonsDataFrame, or a sf object of "POLYGON". The user must enter
a list with 36 SpatialPolygonsDataFrame with emissions for the mechanism CBMZ.}

\item{nr}{Number of repetitions of the emissions period}

\item{dmyhm}{String indicating Day Month Year Hour and Minute in the format
"d-m-Y H:M" e.g.: "01-05-2014 00:00" It represents the time of the first
hour of emissions in Local Time}

\item{tz}{Time zone as required in for function \code{\link{as.POSIXct}}}

\item{crs}{Coordinate reference system, e.g: "+init=epsg:4326". Used to
transform the coordinates of the output}

\item{islist}{logical value to indicate if sdf is a list or not}

\item{object}{Object with class "Evaporative"}

\item{veh}{Character; "one of the 40 vehicle categories shown below.}

\item{fuel}{Character; "Diesel", "Gasoline", "Electricity" or "Natural Gas"}

\item{mph}{Numeric; Speed in miles per hour (optional).}

\item{pol}{Character;}

\item{season}{Character: "winter" or "summer".}

\item{full}{Logical: To return the whole data.table or not.}
}
\value{
Objects of class "EmissionsList" and numeric elements as "units"

Objects of class "Evaporative" or "units"

data.table with emission factors.
}
\description{
\code{EmissionsList} returns a tranformed object with class "EmissionsList".

\code{Evaporative} returns a tranformed object with class "Evaporative" and
units g. This class represents the daily emissions presented by
Mellios G and Ntziachristos (2016) Gasoline evaporation, Tier 2. Eventually
it will be incorporated the techniques of Tier 3.

\code{\link{ef_emfac}} returns emission factors reflecting California, US,
conditions. If the user enter speeds more emission factors are returned.
See details.

\code{emis_wrf} returns a dataframes with columns lat, long, id, pollutants, local time
and GMT time. This dataframe has the proper format to be used with WRF
assimilation system: "ASimilation System 4 WRF (AS4WRF Vera-Vala et al (2016))

The functions listed below are deprecated and will be defunct in
  the near future. When possible, alternative functions with similar
  functionality are also mentioned. Help pages for deprecated functions are
  available at \code{help("-deprecated")}.
}
\section{\code{Evaporative}}{

For \code{Evaporative}, use \code{\link{emis_evap}}.


For \code{running_losses}, use \code{\link{emis_evap}}.


For \code{running_losses}, use \code{\link{emis_evap}}.
}

\examples{
\dontrun{
# do not run
# DEPRECATED
}
\dontrun{
# do not run
# DEPRECATED
}
\dontrun{
# do not run
# DEPRECATED
}
\dontrun{
# do not run
# Use library(eixport)
# eixport::to_as4wrf()
}
\dontrun{
# Do not run
}
\dontrun{
# Do not run
}

}
\references{
https://arb.ca.gov/emfac/emissions-inventory

Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009

Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009
}
\seealso{
\code{\link{vein-deprecated}}

\code{\link{vein-deprecated}}

\code{\link{vein-deprecated}}

\code{\link{vein-deprecated}}
}
\keyword{internal}
