% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abstract.R
\name{abstract}
\alias{abstract}
\alias{abstract.data.frame}
\alias{abstract.default}
\alias{abstract.array}
\alias{abstract.matrix}
\alias{abstract.list}
\alias{abstract.lm}
\alias{abstract.environment}
\alias{abstract.ts}
\title{Turn S3 Objects Into Templates}
\usage{
abstract(x, ...)

\method{abstract}{data.frame}(x, ...)

\method{abstract}{default}(x, ...)

\method{abstract}{array}(x, ...)

\method{abstract}{matrix}(x, ...)

\method{abstract}{list}(x, ...)

\method{abstract}{lm}(x, ...)

\method{abstract}{environment}(x, ...)

\method{abstract}{ts}(x, what = c("start", "end", "frequency"), ...)
}
\arguments{
\item{x}{the object to abstract}

\item{...}{arguments for methods that require further arguments}

\item{what, }{for time series which portion of the \code{ts} attribute to
abstract, by default all three are abstracted, but you can select, any one,
two, or all}
}
\value{
abstracted object
}
\description{
Create templates for use by \code{\link{alike}}. Currently somewhat
experimental; behavior may change in future.
}
\details{
\code{abstract} is intended to create templates for use by
\code{\link{alike}}.  The result of abstraction is often a partially
specified object.  This type of object may not be suited for use in typical
R computations and may cause errors (or worse) if you try to use them as
normal R objects.

There is no guarantee that the \code{abstract}ed object is suitable for use
as a template to \code{alike} as is.  You may need to modify it further so
that it suits your purposes.

\code{abstract} is an S3 generic.  The default method will
dispatch on implicit classes, so if you attempt to \code{abstract} an object
without an explicit \code{abstract} method, it will get abstracted based on
its implicit class.  If you define your own \code{abstract} method and do not
wish further abstraction based on implicit classes do not use
\code{\link{NextMethod}}.

S4 and RC objects are returned unchanged.
}
\section{Time Series}{


\code{\link{alike}} will treat time series parameter components with zero in
them as wildcards.  This function allows you to create these wild card time
series attributes since R does not allow direct creation/modification of
\code{ts} attributes with zero values.

Make sure you do not try to use the templates you create with this for
anything other than as \code{\link{alike}} templates since the result is
likely undefined given R expects non zero values for the \code{ts}
attribute and attempts to prevent such attributes.
}

\examples{
iris.tpl <- abstract(iris)
alike(iris.tpl, iris[1:10, ])
alike(iris.tpl, transform(iris, Species=as.character(Species)))

abstract(1:10)
abstract(matrix(1:9, nrow=3))
abstract(list(1:9, runif(10)))
}
