% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_map.R
\name{draw_map_shiny}
\alias{draw_map_shiny}
\alias{map_summary}
\alias{summary_maps}
\alias{plot_map_list}
\alias{gg_color_hue}
\alias{plot_one_map}
\title{Draws linkage map, parents haplotypes and marker doses
Adapted from MAPpoly}
\usage{
draw_map_shiny(
  left.lim = 0,
  right.lim = 5,
  ch = 1,
  maps,
  ph.p1,
  ph.p2,
  d.p1,
  d.p2,
  snp.names = TRUE
)

map_summary(left.lim = 0, right.lim = 5, ch = 1, maps, d.p1, d.p2)

summary_maps(viewmap, verbose = TRUE)

plot_map_list(viewmap, horiz = TRUE, col = "ggstyle", title = "Linkage group")

gg_color_hue(n)

plot_one_map(x, i = 0, horiz = FALSE, col = "lightgray")
}
\arguments{
\item{viewmap}{object of class \code{viewmap}}

\item{horiz}{logical. If FALSE, the maps are plotted vertically with the first map to the left. 
If TRUE  (default), the maps are plotted horizontally with the first at the bottom}

\item{col}{a vector of colors for the bars or bar components (default = 'lightgrey')
\code{ggstyle} produces maps using the default \code{ggplot} color palette}

\item{title}{a title (string) for the maps (default = 'Linkage group')}

\item{void}{internal function to be documented}
}
\value{
a data frame containing a brief summary of all maps

A \code{data.frame} object containing the name of the markers and their genetic position
}
\description{
This function generates a brief summary table

This function plots a genetic linkage map(s)
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Gabriel Gesteira, \email{gabrielgesteira@usp.br}

Cristiane Taniguti, \email{chtaniguti@tamu.edu}

Marcelo Mollinari, \email{mmollin@ncsu.edu}

Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
\keyword{internal}
