% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classground.R
\name{class.ground}
\alias{class.ground}
\title{Ground and vegetation segmentation in TLS scene}
\usage{
class.ground(data, grid.res, ground.thickness, pix.percentile,
  global.percentile, plot3d)
}
\arguments{
\item{data}{a data.frame containing xyz coordinates}

\item{grid.res}{resolution of the grid's pixel. Default = 1.}

\item{ground.thickness}{the thickness of the soil layer used for primary segmentation. Default = 0.2}

\item{pix.percentile}{the percentile filter to use in each pixel. Default = 100 (i.e., no filter)}

\item{global.percentile}{the percentile filter to use at the plot scale. Default = 100 (i.e., no filter)}

\item{plot3d}{logical, if \emph{TRUE} the result of the segmentation is plotted with the soil in brown and the vegetation in green}
}
\value{
a data frame containing xyz coordinates plus the point class: "ground" or "vegetation"
}
\description{
The \strong{class.ground} function combines three filters to segment the soil and the vegetation in a TLS scene of a forest.
In each pixel of a grid of \emph{grid.res} resolution, the points with a \emph{z} value between \emph{min(z)} and \emph{min(z)} + \emph{ground.thickness} are first classified as ground.
Then, in each pixel, the ground points with \emph{z} above a \emph{pix.percentile} percentile threshold are reclassified as vegetation. During this process, the \emph{z} values of each point relative
to the lower \emph{z} value of all points within the pixel are recorded. This enables application of a last percentile filter apllied at the plot scale, such that all points with a \emph{z} value higher than \emph{global.percentile} are reclassified as vegetation.
}
\details{
The two percentile based filters were successfully tested in:
Muir, J., Goodwin, N., Armston, J., Phinn, S., & Scarth, P. (2017). An accuracy assessment of derived digital elevation models from terrestrial laser scanning in a sub-tropical forested environment. Remote Sensing, 9(8), 843.
}
\examples{
library(viewshed3d)
data(TLSscene)
segmented.scene=class.ground(TLSscene, plot3d = TRUE)
}
