% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp-package.R
\docType{package}
\name{vimp}
\alias{vimp}
\title{vimp: Perform Inference on Algorithm-Agnostic Variable Importance}
\description{
A unified framework for valid statistical inference on algorithm-agnostic
measures of variable importance. You provide the data, a method for 
estimating the conditional mean of the outcome given the covariates,
choose a variable importance measure, and specify variable(s) of interest;
'vimp' takes care of the rest.
}
\section{Author(s)}{

\bold{Maintainer}: Brian Williamson \url{https://bdwilliamson.github.io/}

Methodology authors:
\itemize{
  \item{Brian D. Williamson}
  \item{Jean Feng}
  \item{Peter B. Gilbert}
  \item{Noah R. Simon}
  \item{Marco Carone}
}
}

\section{See Also}{

Manuscripts:
\itemize{
  \item{\doi{10.1111/biom.13392} (R-squared-based variable importance)}
  \item{\doi{10.1111/biom.13389} (Rejoinder to discussion on R-squared-based variable importance article)}
  \item{\url{http://proceedings.mlr.press/v119/williamson20a.html} (general Shapley-based variable importance)}
}
Preprints:
\itemize{
  \item{\url{https://arxiv.org/abs/2004.03683} (general variable importance)}
}

Other useful links:
\itemize{
  \item{\url{https://bdwilliamson.github.io/vimp/}}
  \item{\url{https://github.com/bdwilliamson/vimp}}
  \item{Report bugs at \url{https://github.com/bdwilliamson/vimp/issues}}
}
}

\section{Imports}{

The packages that we import either make the internal code nice (dplyr, magrittr, tibble, rlang, MASS), 
are directly relevant to estimating the conditional mean (SuperLearner) or predictiveness measures (ROCR), 
or are necessary for hypothesis testing (stats).

We suggest several other packages: xgboost, ranger, gam, glmnet, polspline, and quadprog allow 
a flexible library of candidate learners in the Super Learner; ggplot2, cowplot, 
and forcats help with plotting variable importance estimates; testthat and covr 
help with unit tests; and knitr, rmarkdown,
and RCurl help with the vignettes and examples.
}

