% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violinPoint.R
\name{topBottomDistribute}
\alias{topBottomDistribute}
\title{Produce offsets such that points are sorted with most extreme values to right and left}
\usage{
topBottomDistribute(x, frowney = FALSE, prop = TRUE)
}
\arguments{
\item{x}{the elements to be sorted}

\item{frowney}{if TRUE then sort minimums to the outside, otherwise sort maximums to the outside}

\item{prop}{if FALSE then return an ordering of the data with extremes on the outside. If TRUE then return a sequence between 0 and 1 sorted by the ordering}
}
\value{
a vector of the same length as x with values ranging between 0 and 1 if prop is TRUE or an ordering of 1 to length(x)
}
\description{
Produce offsets to generate smile-like or frown-like distributions of points. That is sorting the points so that the most extreme values alternate between the left and right e.g. (max,3rd max,...,4th max, 2nd max). The function returns either a proportion between 0 and 1 (useful for plotting) or an order
}
\examples{
topBottomDistribute(1:10)
topBottomDistribute(1:10,TRUE)
}

