% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acfToDf.R
\name{acfToDf}
\alias{acfToDf}
\title{Computes temporal autocorrelation in a vector, and returns a dataframe for easy plotting.}
\usage{
acfToDf(
  x = NULL,
  lag.max = 100,
  length.out = 10
  )
}
\arguments{
\item{x}{numeric vector. Must represent a variable sampled at regular times.}

\item{lag.max}{integer, number of lags over which to compute temporal autocorrelation.}

\item{length.out}{integer, total number of lags to consider for plotting. Should be a subset of \code{lag.max}.}
}
\value{
A dataframe with the columns:
#' \itemize{
  \item \emph{lag}: numeric, lag in the time units of \code{x} with a maximum determined by \code{lag.max}, and a number of unique values determined by \code{length.out}
  \item \emph{acf}: Pearson correlation index returned by the \code{\link{acf}} for a given number of lags for the given lag.
  \item \emph{ci.max}: Maximum value of the confidence interval of \code{acf}.
  \item \emph{ci.min}: Minimum value of the confidence interval of \code{acf}.
}
}
\description{
It reads a vector representing a time series, applies \code{\link{acf}} for a given number of lags
}
\details{
This function computes temporal autocorrelation of a given vector using \code{\link{acf}}, and returns a dataframe ready for easy plotting with \code{\link{plotAcf}}.
}
\examples{

#getting a driver
data(driverA)

#computing temporal autocorrelations
x.df <- acfToDf(
  x = driverA,
  lag.max = 1000,
  length.out = 100
)
str(x.df)

#plotting output
plotAcf(x.df)

}
\seealso{
\code{\link{acf}}, \code{\link{plotAcf}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
