% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeCollinearity.R
\name{removeCollinearity}
\alias{removeCollinearity}
\title{Remove collinearity among variables of a a raster stack}
\usage{
removeCollinearity(raster.stack, multicollinearity.cutoff = 0.7,
  select.variables = FALSE, sample.points = FALSE, nb.points = 10000,
  plot = FALSE)
}
\arguments{
\item{raster.stack}{a RasterStack object, in which each layer represent an environmental 
variable.}

\item{multicollinearity.cutoff}{a numeric value corresponding to the cutoff
of correlation above which to group variables.}

\item{select.variables}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, then the
function will choose one variable among each group to return a vector of
non correlated variables (see details). If \code{FALSE}, the function will return a list
containing the groups of correlated variables.}

\item{sample.points}{\code{TRUE} or \code{FALSE}. If you have a large
raster file then use this parameter to sample a number of points equal to
\code{nb.points}.}

\item{nb.points}{a numeric value. Only useful if \code{sample.points = TRUE}.
The number of sampled points from the raster, to perform the PCA. A too small
value may not be representative of the environmental conditions in your raster.}

\item{plot}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, the hierarchical
ascendant classification used to group variables will be plotted.}
}
\value{
a vector of non correlated variables, or a list where each element is a
group of non correlated variables.
}
\description{
This functions analyses the correlation among variables of the provideded
stack of environmental variables (using Pearson's R), and can return a 
vector containing names of variables that are not intercorrelated, or a list
containing grouping variables according to their degree of collinearity.
}
\details{
This function uses the Pearson's correlation coefficient to analyse 
correlation among variables. This coefficient is then used to compute a
distance matrix, which in turn is used it compute an ascendant hierarchical
classification, with the '\emph{complete}' method (see 
\code{\link[stats]{hclust}}). If at least one correlation above the \code{
multicollinearity.cutoff} is detected, then the variables will be grouped
according to their degree of correlation. 

If \code{select.variables = TRUE}, then the function will return a vector
containing variables that are not intercorrelated.
The variables not correlated to any other variables are automatically included
in this vector. For each group of intercorrelated variables, one variable will
be randomly chosen and included in this vector.
}
\examples{
# Create an example stack with six environmental variables
a <- matrix(rep(dnorm(1:100, 50, sd = 25)), 
            nrow = 100, ncol = 100, byrow = TRUE)
env <- stack(raster(a * dnorm(1:100, 50, sd = 25)),
             raster(a * 1:100),
             raster(a * logisticFun(1:100, alpha = 10, beta = 70)),
             raster(t(a)),
             raster(exp(a)),
             raster(log(a)))
names(env) <- paste("Var", 1:6, sep = "")   
   
# Defaults settings: cutoff at 0.7
removeCollinearity(env, plot = TRUE)

# Changing cutoff to 0.5
removeCollinearity(env, plot = TRUE, multicollinearity.cutoff = 0.5)

# Automatic selection of variables not intercorrelated
removeCollinearity(env, plot = TRUE, select.variables = TRUE)

# Assuming a very large raster file: selecting a subset of points
removeCollinearity(env, plot = TRUE, select.variables = TRUE,
                   sample.points = TRUE, nb.points = 5000)


}
\author{
Boris Leroy \email{leroy.boris@gmail.com}

with help from C. N. Meynard, C. Bellard & F. Courchamp
}
