% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visSave.R
\name{visSave}
\alias{visSave}
\title{Save a a visNetwork object to an HTML file}
\usage{
visSave(graph, file, selfcontained = TRUE)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{file}{File to save HTML into}

\item{selfcontained}{Whether to save the HTML as a single self-contained file
(with external resources base64 encoded) or a file with external resources
placed in an adjacent directory.}
}
\description{
Save a a visNetwork object to an HTML file for sharing with others. The HTML can
include it's dependencies in an adjacent directory or can bundle all
dependencies into the HTML file (via base64 encoding).
}
\examples{

\dontrun{
nodes <- data.frame(id = 1:3, group = c("B", "A", "B"))
edges <- data.frame(from = c(1,2), to = c(2,3))

network <- visNetwork(nodes, edges)
network

network \%>\% visSave(file = "network.html")
# same as
visSave(network, file = "network.html")

}
}

