% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visUpdateNodes.R
\name{visUpdateNodes}
\alias{visUpdateNodes}
\title{Function to update the information of nodes, with shiny only.}
\usage{
visUpdateNodes(graph, nodes, updateOptions = TRUE, legend = FALSE)
}
\arguments{
\item{graph}{: a \code{\link{visNetworkProxy}}  object}

\item{nodes}{: data.frame with the information of nodes. Needed at least column "id". See \link{visNodes} 
\itemize{
 \item{"id"}{ : id of the node, needed in the definition of edges and for update nodes}
 \item{"label"}{ : label of the node}
 \item{"group"}{ : group of the node. Groups can be configure with \link{visGroups}}
 \item{"value"}{ : size of the node}
 \item{"title"}{ : tooltip of the node}
 \item{...}{}
}}

\item{updateOptions}{: Boolean. Update options (nodesIdSelection & selectedBy) if needed ? Default to TRUE.}

\item{legend}{: Boolean. Update nodes on legend ? Default to FALSE}
}
\description{
Function to update the information of nodes, with shiny only. You can also use this function passing new nodes.
The link is based on id.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
