% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationHelper.R
\name{tableDoc}
\alias{tableDoc}
\title{Helper for consistent documentation of \code{tables}.}
\arguments{
\item{estimateName}{A named list of estimate names to join, sorted by
computation order. Use \verb{<...>} to indicate estimate names.}

\item{groupColumn}{Columns to use as group labels, to see options use
\code{tableColumns(result)}. By default, the name of the new group will be the
tidy* column names separated by ";". To specify a custom group name, use a
named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts to sentence case. Use \code{rename} to customise specific column names.}

\item{rename}{A named vector to customise column names, e.g.,
c("Database name" = "cdm_name"). The function renames all column names
not specified here into a tidy* format.}

\item{type}{The desired format of the output table. See \code{tableType()} for
allowed options.}

\item{columnOrder}{Character vector establishing the position of the columns
in the formatted table. Columns in either header, groupColumn, or hide will
be ignored.}

\item{factor}{A named list where names refer to columns (see available columns
in \code{tableColumns()}) and list elements are the level order of that column
to arrange the results. The column order in the list will be used for
arranging the result.}

\item{style}{A character string or custom R code to define the visual
formatting of the table. This argument can be provided in two ways:
\enumerate{
\item Pre-defined Styles (Character String): Use a name for a built-in style
(e.g., "darwin"). See tableStyle() for available options.
\item Custom Code (Advanced): Supply a block of custom R code. This code must be
specific to the table type. See tableStyleCode() for structural examples.
}}

\item{showMinCellCount}{If \code{TRUE}, suppressed estimates will be indicated with
"<\{min_cell_count\}", otherwise, the default \code{na} defined in \code{.options} will be
used.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default values.}
}
\description{
Helper for consistent documentation of \code{tables}.
}
\keyword{internal}
