% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visr.R
\name{visr}
\alias{visr}
\alias{visr.default}
\alias{visr.survfit}
\alias{visr.attrition}
\alias{visr.tidycuminc}
\title{Plot a supported S3 object}
\usage{
visr(x, ...)

\method{visr}{default}(x, ...)

\method{visr}{survfit}(
  x = NULL,
  x_label = NULL,
  y_label = NULL,
  x_units = NULL,
  x_ticks = NULL,
  y_ticks = NULL,
  fun = "surv",
  legend_position = "right",
  ...
)

\method{visr}{attrition}(
  x,
  description_column_name = "Criteria",
  value_column_name = "Remaining N",
  complement_column_name = "",
  box_width = 50,
  font_size = 12,
  fill = "white",
  border = "black",
  ...
)

\method{visr}{tidycuminc}(
  x = NULL,
  x_label = "Time",
  y_label = "Cumulative Incidence",
  x_units = NULL,
  x_ticks = pretty(x$tidy$time, 10),
  y_ticks = pretty(c(0, 1), 5),
  legend_position = "right",
  ...
)
}
\arguments{
\item{x}{Object of class \code{survfit}, \code{attritiontable}, or \code{tidycuminc}}

\item{...}{other arguments passed on to the method}

\item{x_label}{\code{character} Label for the x-axis. When not specified,
the function will look for \code{"PARAM"} or \code{"PARAMCD"} information in the original data set (CDISC standards).
If no \code{"PARAM"}/\code{"PARAMCD"} information is available, the default x-axis label is \code{"Time"}.}

\item{y_label}{\code{character} Label for the y-axis. When not specified,
the default will do a proposal, depending on the \code{fun} argument.}

\item{x_units}{Unit to be added to the x_label (x_label (x_unit)).
Default is NULL.}

\item{x_ticks}{Ticks for the x-axis. When not specified, the default will
do a proposal.}

\item{y_ticks}{Ticks for the y-axis. When not specified,
the default will do a proposal based on the \code{fun} argument.}

\item{fun}{Function that represents the scale of the estimate.
The current options are:
\itemize{
\item{\code{surv}}{ is the survival probability. This is the default.}
\item{\code{log}}{ is log of the survival probability}
\item{\code{event}}{ is the failure probability}
\item{\code{cloglog}}{ is log(-log(survival probability))}
\item{\code{pct}}{ is survival as a percentage}
\item{\code{logpct}}{ is log survival as a percentage}
\item{\code{cumhaz}}{ is the cumulative hazard}
}}

\item{legend_position}{Specifies the legend position in the plot.
Character values allowed are "top" "left" "bottom" "right".
Numeric coordinates are also allowed.
Default is "right".}

\item{description_column_name}{\code{character} Name of the column containing
the inclusion descriptions}

\item{value_column_name}{\code{character} Name of the column containing the
remaining sample counts}

\item{complement_column_name}{\code{character} Optional: Name of the column
containing the exclusion descriptions}

\item{box_width}{\code{character} The box width for each box in the flow
chart}

\item{font_size}{\code{character} The fontsize in pt}

\item{fill}{The color (string or hexcode) to use to fill the boxes in the
flowchart}

\item{border}{The color (string or hexcode) to use for the borders of the
boxes in the flowchart}
}
\value{
Object of class \code{ggplot} and \code{ggsurvplot} for \code{survfit} objects.
}
\description{
S3 method for creating plots directly from objects using \code{ggplot2},
similar to the base R \code{plot()} function.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
S3 function to draw a Consort flow diagram chart.
}
\examples{

# fit KM
km_fit <- survival::survfit(survival::Surv(AVAL, 1 - CNSR) ~ TRTP, data = adtte)

# plot curves using survival plot function
plot(km_fit)

# plot same curves using visR::visr plotting function
visR::visr(km_fit)

# estimate KM using visR wrapper
survfit_object <- visR::estimate_KM(data = adtte, strata = "TRTP")

# Plot survival probability
visR::visr(survfit_object, fun = "surv")

# Plot survival percentage
visR::visr(survfit_object, fun = "pct")

# Plot cumulative hazard
visR::visr(survfit_object, fun = "cloglog")


## Create attrition
attrition <- visR::get_attrition(adtte,
  criteria_descriptions = c(
    "1. Not in Placebo Group",
    "2. Be 75 years of age or older.",
    "3. White",
    "4. Female"
  ),
  criteria_conditions = c(
    "TRTP != 'Placebo'",
    "AGE >= 75",
    "RACE=='WHITE'",
    "SEX=='F'"
  ),
  subject_column_name = "USUBJID"
)

## Draw a CONSORT attrition chart without specifying extra text for the complement
attrition \%>\%
  visr("Criteria", "Remaining N")

## Add detailed complement descriptions to the "exclusion" part of the CONSORT diagram
# Step 1. Add new column to attrition dataframe
attrition$Complement <- c(
  "NA",
  "Placebo Group",
  "Younger than 75 years",
  "Non-White",
  "Male"
)

# Step 2. Define the name of the column in the call to the plotting function
attrition \%>\%
  visr("Criteria", "Remaining N", "Complement")

## Styling the CONSORT flowchart
# Change the fill and outline of the boxes in the flowchart
attrition \%>\%
  visr("Criteria", "Remaining N", "Complement", fill = "lightblue", border = "grey")

## Adjust the font size in the boxes
attrition \%>\%
  visr("Criteria", "Remaining N", font_size = 10)

}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
