% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndvi2.R
\name{ndvi2}
\alias{ndvi2}
\title{Calculate and plot a 2-band NDVI.}
\usage{
ndvi2(s, b1, b2)
}
\arguments{
\item{s}{Spectral data in the format of visa's Spectra object, spectra.data.frame or spectra.matrix.}

\item{b1}{A integer number which defines the wavelength of the 1st spectral band.}

\item{b2}{A integer number which defines the wavelength of the 2nd spectral band.}
}
\value{
\item{ndvi}{The returned values are the new NDVI.}
}
\description{
This function calculates a 2-band NDVI using the \code{\link{nsr}} function.
}
\details{
Calculate a NDVI with two specific bands of choice. The new NDVI follows the
the standard formula \deqn{NDVI = (\lambda_i + \lambda_j)/(\lambda_i - \lambda_j)}.
Bands i and j correspond to the b1 and b2 input arguments, respectively. Wavelength
indexes are determined based on the first argument 's'.
}
\examples{
library(visa)
s <- NSpec.DF$spectra
ndvi2(s, 780, 680)

}
