% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectra.R
\docType{methods}
\name{spectra}
\alias{spectra}
\alias{spectra,Spectra-method}
\alias{spectra,Spectra,ANY-method}
\alias{spectra,data.frame-method}
\alias{spectra,data.frame,ANY-method}
\alias{spectra,matrix-method}
\alias{spectra,matrix,ANY-method}
\title{Access the spectra data of 'SpectraDatabase'.}
\usage{
spectra(object, ...)

\S4method{spectra}{Spectra}(object, ...)

\S4method{spectra}{data.frame}(object, ...)

\S4method{spectra}{matrix}(object, ...)
}
\arguments{
\item{object}{A Spectra object, spectra.data.frame, or spectra.matrix.}

\item{...}{Other options.}
}
\description{
Functions to access slot data of the Class Spectra.
}
\details{
Construct generic functions for the Spectra object, spectra.data.frame,
and spectra.matrix.
}
\examples{
# For the S4 class 'Spectra'
library(visa)
data(NSpec.DB)
spectra_matrix <- spectra(NSpec.DB)
# For the spectra data.frame
data(NSpec.DF)
spectra_matrix <- spectra(NSpec.DF)

}
