% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_plot.R
\name{parallel_plot}
\alias{parallel_plot}
\title{parallel_plot}
\usage{
parallel_plot(
  data,
  ordinalAccessor,
  valueAccessor,
  seriesAccessor,
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{data}{required to be a valid, R data frame. Data used to create chart, an array of objects which includes keys that map to chart accessors.}

\item{ordinalAccessor}{String. Key used to determine line's categorical property. (similar to x in ggplot)}

\item{valueAccessor}{String. Key used to determine line's numeric property. (similar to y in ggplot)}

\item{seriesAccessor}{String. Key used to determine series (e.g., color/texture).}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/parallel-plot#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/parallel-plot}{@visa/parallel-plot}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/parallel-plot}{@visa/parallel-plot}.}
}
\value{
a visaChart htmlwidget object for plotting a parallel plot
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/parallel-plot}{@visa/parallel-plot} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of parallel-plot in action:

\if{html}{\figure{parallel-plot-1.png}{options: width=400 alt="example parallel plot"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/parallel-plot}{@visa/parallel-plot}.
}
\examples{
library(dplyr)
ChickWeight \%>\%
 filter(Chick==1 | Chick == 4) \%>\%
 parallel_plot("Time", "weight", "Chick",
               showBaselineX=FALSE,
               xAxis=list(label="Time",format="0a", visible=TRUE),
               yAxis=list(label="Weight", visible=FALSE, gridVisible=FALSE),
               mainTitle = "Selected chick weight over time",
               dataLabel=list(visible = TRUE,
                              labelAccessor = "weight",
                              placement = "bottom-right",
                              format = "0a"))
}
