% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{vmtable}
\alias{vmtable}
\title{Rounds a contingency table of meteor magnitude frequencies}
\usage{
vmtable(mt)
}
\arguments{
\item{mt}{table; A two-dimensional contingency table of meteor magnitude frequencies.}
}
\value{
A rounded contingency table of meteor magnitudes is returned.
}
\description{
The meteor magnitude contingency table of VMDB contains half meteor counts (e.g. \code{3.5}).
This function converts these frequencies to integer values.
}
\details{
The contingency table of meteor magnitudes \code{mt} must be two-dimensional.
The row names refer to the magnitude observations.
Column names must be integer meteor magnitude values.
Also, the columns must be sorted in ascending or descending order of meteor magnitude.

A sum-preserving algorithm is used for rounding.
It ensures that the total frequency of meteors per observation is preserved.
The marginal frequencies of the magnitudes are also preserved with
the restriction that the deviation is at most \eqn{\pm 0.5}.
If the total sum of a meteor magnitude is integer,
then the deviation is \eqn{\pm 0}.

The algorithm is asymptotic. This means that the more meteors the table contains,
the more unbiased is the result of the rounding.
}
\examples{
# For example, create a contingency table of meteor magnitudes
mt <- as.table(matrix(
    c(
        0.0, 0.0, 2.5, 0.5, 0.0, 1.0,
        0.0, 1.5, 2.0, 0.5, 0.0, 0.0,
        1.0, 0.0, 0.0, 3.0, 2.5, 0.5
    ), nrow = 3, ncol = 6, byrow = TRUE
))
colnames(mt) <- seq(6)
rownames(mt) <- c('A', 'B', 'C')
mt
margin.table(mt, 1)
margin.table(mt, 2)

# contingency table with integer values
(mt.int <- vmtable(mt))
margin.table(mt.int, 1)
margin.table(mt.int, 2)
}
