% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volskew.R
\name{volskew}
\alias{volskew}
\title{Volatility Skew Visualization}
\usage{
volskew(symbol, type = "call", spot = "current", r, ll = 0.75,
  ul = 1.25, days_out = 50, d1 = 0, d2 = 0, d3 = 0, d4 = 0,
  d5 = 0)
}
\arguments{
\item{symbol}{Ticker symbol for a publicly traded company}

\item{type}{"call" or "put" option volatility skew}

\item{spot}{This is the current price of the stock, if blank it defaults to the previous adjusted close}

\item{r}{risk-free rate, annualized and continuously-compounded}

\item{ll}{lower limit, set to 0.75}

\item{ul}{upper limit, set to 1.25}

\item{days_out}{keep at 50}

\item{d1}{dividend yield}

\item{d2}{dividend yield}

\item{d3}{dividend yield}

\item{d4}{dividend yield}

\item{d5}{dividend yield}
}
\value{
Plots a 3d Graph in the Viewer tab
}
\description{
Creates a 3D Plot of the Volatility Skew
}
\examples{
volskew("^SPX", type = "call", spot = 2900, r = 0.02)
}
