\name{visualize.cauchy}
\alias{visualize.cauchy}
\title{
Visualize Cauchy Distribution
}
\description{
Generates a plot of the Cauchy distribution with user specified parameters.
}
\usage{
visualize.cauchy(stat = 1, location = 2, scale = 1, section = "lower")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{stat}{
a statistic to obtain the probability from. When using the "bounded" condition, you must supply the parameter as \code{stat = c(lower_bound, upper_bound)}. Otherwise, a simple \code{stat = desired_point} will suffice.
}
  \item{location}{
  location parameter
}
  \item{scale}{
  scale parameter
}
  \item{section}{
Select how you want the statistic(s) evaluated via \code{section=} either \code{"lower"},\code{"bounded"}, \code{"upper"}, or\code{"tails"}.  
}
}
\value{
Returns a plot of the distribution according to the conditions supplied.
}
\author{
James Balamuta
}
\seealso{
  \code{\link{visualize.it}}, \code{\link{dcauchy}}.
}
\examples{
#Evaluates lower tail.
visualize.cauchy(stat = 1, location = 4, scale = 2, section = "lower") 

#Evaluates bounded region.
visualize.cauchy(stat = c(3,5), location = 5, scale = 3, section = "bounded") 

#Evaluates upper tail.
visualize.cauchy(stat = 1, location = 4, scale = 2, section = "upper") 
}
\keyword{ visualize }