% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clustering.R
\name{compute_gapstat}
\alias{compute_gapstat}
\title{Compute Gap statistic for clustered data}
\usage{
compute_gapstat(df, clusters, gap_B = 50, max_k = 14)
}
\arguments{
\item{df}{the data used to compute clusters}

\item{clusters}{output of \code{\link[=compute_clusters]{compute_clusters()}} or \code{\link[fastcluster:hclust]{fastcluster::hclust()}}}

\item{gap_B}{number of bootstrap samples for \code{\link[cluster:clusGap]{cluster::clusGap()}} function. Default is 50.}

\item{max_k}{maximum number of clusters to compute the statistic. Default is 14.}
}
\value{
a data frame with the Tab component of \code{\link[cluster:clusGap]{cluster::clusGap()}} results
}
\description{
Compute Gap statistic for clustered data
}
\examples{
data_to_cluster <- iris[c("Petal.Length", "Sepal.Length")]
dmat <- compute_dmat(data_to_cluster, "euclidean", TRUE)
clusters <- compute_clusters(dmat, "complete")
gap_results <- compute_gapstat(scale(data_to_cluster), clusters)
head(gap_results)
}
