% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lorenz.R
\name{create_lorenz}
\alias{create_lorenz}
\title{Calculate the Lorenz Curve and Gini Coefficient in a Person Query}
\usage{
create_lorenz(data, metric, return = "plot")
}
\arguments{
\item{data}{Data frame containing a Person Query.}

\item{metric}{Character string identifying the metric to be used for the
Lorenz curve and Gini coefficient calculation.}

\item{return}{Character string identifying the return type. Options are:
\itemize{
\item \code{"gini"} - Numeric value representing the Gini coefficient.
\item \code{"table"} - Data frame containing a summary table of population share and value share.
\item \code{"plot"} (default) - \code{ggplot} object representing a plot of the Lorenz curve.
}}
}
\description{
This function computes the Gini coefficient and plots the Lorenz curve based
on a selected metric from a Person Query data frame. It provides a way to
measure inequality in the distribution of the selected metric.This function
can be integrated into a larger analysis pipeline to assess inequality in
metric distribution.
}
\examples{
create_lorenz(data = pq_data, metric = "Emails_sent", return = "gini")

create_lorenz(data = pq_data, metric = "Emails_sent", return = "plot")

create_lorenz(data = pq_data, metric = "Emails_sent", return = "table")
}
