% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_variable_importance.R
\name{local_variable_importance}
\alias{local_variable_importance}
\title{Local Variable Importance measure based on Ceteris Paribus profiles.}
\usage{
local_variable_importance(profiles, data, absolute_deviation = TRUE,
  point = TRUE, density = TRUE)
}
\arguments{
\item{profiles}{data.frame generated by \code{ingredients::ceteris_paribus()}}

\item{data}{data.frame with raw data to model}

\item{absolute_deviation}{logical parameter, if `absolute_deviation = TRUE` then measure is calculated as absolute deviation, else is calculated as a root from average squares}

\item{point}{logical parameter, if `point = TRUE` then measure is calculated as a distance from f(x), else measure is calculated as a distance from average profiles}

\item{density}{logical parameter, if `density = TRUE` then measure is weighted based on the density of variable, else is not weighted}
}
\value{
A data.frame of the class 'local_variable_importance'.
It's a data.frame with calculated local variable importance measure.
}
\description{
This function calculate local importance measure in eight variants. We obtain eight variants measure through the possible options of three parameters such as `absolute_deviation`, `point` and `density`.
}
\examples{


library("DALEX")
data(apartments)

library("randomForest")
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface +
                                    floor + no.rooms, data = apartments)

explainer_rf <- explain(apartments_rf_model, data = apartmentsTest[,2:5],
                        y = apartmentsTest$m2.price)

new_apartment <- data.frame(construction.year = 1998, surface = 88, floor = 2L, no.rooms = 3)

library("ingredients")
profiles <- ceteris_paribus(explainer_rf, new_apartment)

library("vivo")
local_variable_importance(profiles, apartments[,2:5],
                          absolute_deviation = TRUE, point = TRUE, density = TRUE)

local_variable_importance(profiles, apartments[,2:5],
                          absolute_deviation = TRUE, point = TRUE, density = FALSE)

local_variable_importance(profiles, apartments[,2:5],
                          absolute_deviation = TRUE, point = FALSE, density = TRUE)



}
