% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocalgraphs.R
\docType{package}
\name{vocaldia-package}
\alias{vocaldia}
\alias{vocaldia-package}
\title{vocaldia: Create and Manipulate Vocalisation Diagrams}
\description{
Create adjacency matrices of vocalisation graphs from
  dataframes containing sequences of speech and silence intervals,
  transforming these matrices into Markov diagrams, and generating
  datasets for classification of these diagrams by 'flattening' them
  and adding global properties (functionals) etc.  Vocalisation
  diagrams date back to early work in psychiatry (Jaffe and Feldstein,
  1970) and social psychology (Dabbs and Ruback, 1987) but have only
  recently been employed as a data representation method for machine
  learning tasks including meeting segmentation (Luz, 2012)
  <doi:10.1145/2328967.2328970> and classification (Luz,
  2013) <doi:10.1145/2522848.2533788>.
}
\references{
S. Luz. Automatic identification of experts and performance
  prediction in the multimodal math data corpus through analysis
  of speech interaction. In \emph{Proceedings of the 15th ACM on
  International Conference on Multimodal Interaction, ICMI'13},
  pages 575--582, New York, NY, USA, 2013. ACM.

  S. Luz. The non-verbal structure of patient case discussions in
  multidisciplinary medical team meetings. \emph{ACM Transactions on
  Information Systems}, 30(3):17:1--17:24, 2012

  Dabbs, J. M. J. and Ruback, B. Dimensions of group process: Amount and
  structure of vocal interaction. \emph{Advances in Experimental Social
  Psychology} 20, 123-169, 1987.

  Jaffe , J. and Feldstein, S. Rhythms of
  dialogue. ser. \emph{Personality and Psychopathology}. Academic
  Press, New York, 1976.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://git.ecdf.ed.ac.uk/sluzfil/vocaldia}
  \item Report bugs at \url{https://git.ecdf.ed.ac.uk/sluzfil/vocaldia/issues}
}

}
\author{
Saturnino Luz \email{luzs@acm.org}
}
