% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rttm.R
\name{read_rttm}
\alias{read_rttm}
\title{Read RTTM files}
\usage{
read_rttm(fromRttm)
}
\arguments{
\item{fromRttm}{A directory/folder containing RTTM files.}
}
\value{
A list containing data frames obtained from standard RTTM files. See 'Details'.
}
\description{
Read Rich Transcription Time Marked (RTTM) files in \code{fromRttm} directory.
}
\details{
The Rich Transcription Time Marked (RTTM) files are space-delimited text files containing one turn per line defined by NIST - National Institute of Standards and Technology. Each line containing ten fields:

\code{type} Type: segment type; should always by SPEAKER.

\code{file} File ID: file name; basename of the recording minus extension (e.g., rec1_a).

\code{chnl} Channel ID: channel (1-indexed) that turn is on; should always be 1.

\code{tbeg} Turn Onset -- onset of turn in seconds from beginning of recording.

\code{tdur} Turn Duration -- duration of turn in seconds.

\code{ortho} Orthography Field -- should always by <NA>.

\code{stype} Speaker Type -- should always be <NA>.

\code{name} Speaker Name -- name of speaker of turn; should be unique within scope of each file.

\code{conf} Confidence Score -- system confidence (probability) that information is correct; should always be <NA>.

\code{slat} Signal Lookahead Time -- should always be <NA>.
}
\examples{
library(voice)

url0 <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/rttm/sherlock0.rttm'
download.file(url0, destfile = paste0(tempdir(), '/sherlock0.rttm'))
url1 <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/rttm/sherlock1.rttm'
download.file(url0, destfile = paste0(tempdir(), '/sherlock1.rttm'))

(rttm <- voice::read_rttm(tempdir()))
class(rttm)
lapply(rttm, class)
}
\references{
\url{https://www.nist.gov/system/files/documents/itl/iad/mig/KWS15-evalplan-v05.pdf}
}
\seealso{
\code{voice::enrich_rttm}
}
