% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_mistnet}
\alias{install_mistnet}
\title{Install 'MistNet' libraries}
\usage{
install_mistnet(
  version = "1.12.1",
  reinstall = FALSE,
  path = install_path(),
  timeout = 360,
  ...
)
}
\arguments{
\item{version}{The 'LibTorch' version to install.}

\item{reinstall}{Re-install 'MistNet' even if its already installed?}

\item{path}{Optional path to install or check for an already existing installation.}

\item{timeout}{Optional timeout in seconds for large file download.}

\item{...}{other optional arguments (like \code{`load`} for manual installation).}
}
\value{
no value returned. Installs libraries into the package
}
\description{
Installs libraries and dependencies for using 'MistNet'.
}
\details{
By default libraries are installed in the 'vol2birdR' package directory.

When using \code{path} to install in a specific location, make sure the \code{MISTNET_HOME} environment
variable is set to this same path to reuse this installation.

The \code{TORCH_INSTALL} environment
variable can be set to \code{0} to prevent auto-installing 'LibTorch and \code{TORCH_LOAD} set to \code{0}
to avoid loading dependencies automatically. These environment variables are meant for advanced use
cases and troubleshooting only.

When timeout error occurs during library archive download, or length of downloaded files differ from
reported length, an increase of the \code{timeout} value should help.
}
\examples{
\donttest{
install_mistnet()
}

}
\seealso{
\itemize{
\item \code{\link[=install_mistnet_from_file]{install_mistnet_from_file()}}
}
}
