% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{volume}
\alias{volume}
\title{The main function for volume approximation of a convex Polytope (H-polytope, V-polytope or a zonotope)}
\usage{
volume(P, walk_step = NULL, error = NULL, InnerBall = NULL,
  Algo = NULL, WalkType = NULL, rounding = NULL, Parameters = NULL)
}
\arguments{
\item{P}{A convex polytope. It is an object from class (a) Hpolytope or (b) Vpolytope or (c) Zonotope.}

\item{walk_step}{Optional. The number of the steps for the random walk. The default value is \eqn{\lfloor 10 + d/10\rfloor} for SequenceOfBalls and \eqn{1} for CoolingGaussian.}

\item{error}{Optional. Declare the upper bound for the approximation error. The default value is \eqn{1} for SequenceOfBalls and \eqn{0.1} for CoolingGaussian.}

\item{InnerBall}{Optional. A \eqn{d+1} vector that contains an inner ball. The first \eqn{d} coordinates corresponds to the center and the last one to the radius of the ball. If it is not given then for H-polytopes the Chebychev ball is computed, for V-polytopes \eqn{d+1} vertices are picked randomly and the Chebychev ball of the defined simplex is computed. For a zonotope that is defined by the Minkowski sum of \eqn{m} segments we compute the maximal \eqn{r} s.t.: \eqn{re_i\in Z} for all \eqn{i=1,\dots ,d}, then the ball centered at the origin with radius \eqn{r/\sqrt{d}} is an inscribed ball.}

\item{Algo}{Optional. A string that declares which algorithm to use: a) \code{'SoB'} for SequenceOfBalls or b) \code{'CG'} for CoolingGaussian.}

\item{WalkType}{Optional. A string that declares the random walk method: a) \code{'CDHR'} for Coordinate Directions Hit-and-Run, b) \code{'RDHR'} for Random Directions Hit-and-Run or c) \code{'BW'} for Ball Walk. The default walk is \code{'CDHR'}.}

\item{rounding}{Optional. A boolean parameter for rounding. The default value is \code{FALSE}.}

\item{Parameters}{Optional. A list for the parameters of the algorithms:
\itemize{
\item{\code{Window} }{ The length of the sliding window for CG algorithm. The default value is \eqn{500+4dimension^2}.}
 \item{\code{C} }{ A constant for the lower bound of \eqn{variance/mean^2} in schedule annealing of CG algorithm. The default value is \eqn{2}.}
 \item{\code{N} }{ The number of points we sample in each step of schedule annealing in CG algorithm. The default value is \eqn{500C + dimension^2 / 2}.}
 \item{\code{ratio} }{ Parameter of schedule annealing of CG algorithm, larger ratio means larger steps in schedule annealing. The default value is \eqn{1 - 1/dimension}.}
 \item{\code{frac} }{ The fraction of the total error to spend in the first gaussian in CG algorithm. The default value is \eqn{0.1}.}
 \item{\code{BW_rad} }{ The radius for the ball walk. The default value is \eqn{4r/dimension}, where \eqn{r} is the radius of the inscribed ball of the polytope.}
}}
}
\value{
The approximation of the volume of a convex polytope.
}
\description{
For the volume approximation can be used two algorithms. Either SequenceOfBalls or CoolingGaussian. A H-polytope with \eqn{m} facets is described by a \eqn{m\times d} matrix \eqn{A} and a \eqn{m}-dimensional vector \eqn{b}, s.t.: \eqn{Ax\leq b}. A V-polytope is defined as the convex hull of \eqn{m} \eqn{d}-dimensional points which correspond to the vertices of P. A zonotope is desrcibed by the Minkowski sum of \eqn{m} \eqn{d}-dimensional segments.
}
\examples{
# calling SOB algorithm for a H-polytope (2d unit simplex)
P = GenSimplex(2,'H')
vol = volume(P)

# calling CG algorithm for a V-polytope (3d simplex)
P = GenSimplex(2,'V')
vol = volume(P, Algo = "CG")

# calling CG algorithm for a 2-dimensional zonotope defined as the Minkowski sum of 4 segments
Z = GenZonotope(2, 4)
vol = volume(Z, WalkType = "RDHR", walk_step = 5)
}
\references{
\cite{I.Z.Emiris and V. Fisikopoulos,
\dQuote{Practical polytope volume approximation,} \emph{ACM Trans. Math. Soft.,} 2014.},

\cite{B. Cousins and S. Vempala, \dQuote{A practical volume algorithm,} \emph{Springer-Verlag Berlin Heidelberg and The Mathematical Programming Society,} 2015.}
}
