% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_cross.R
\name{gen_cross}
\alias{gen_cross}
\title{Generator function for cross polytopes}
\usage{
gen_cross(dimension, representation = "H")
}
\arguments{
\item{dimension}{The dimension of the cross polytope.}

\item{representation}{A string to declare the representation. It has to be \code{'H'} for H-representation or \code{'V'} for V-representation. Default valus is 'H'.}
}
\value{
A polytope class representing a cross polytope in H- or V-representation.
}
\description{
This function generates the \eqn{d}-dimensional cross polytope in H- or V-representation.
}
\examples{
# generate a 10-dimensional cross polytope in H-representation
P = gen_cross(5, 'H')

# generate a 15-dimension cross polytope in V-representation
P = gen_cross(15, 'V')
}
