% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_counts}
\alias{plot_counts}
\title{Output a frequency plot}
\usage{
plot_counts(data, cols, cross = NULL, metric = FALSE, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{cross}{Optional, a grouping column. The column name without quotes.}

\item{metric}{When crossing variables, the cross column parameter can contain categorical or metric values.
By default, the cross column selection is treated as categorical data.
Set metric to TRUE, to treat it as metric and calculate correlations.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate plot function.}
}
\value{
A ggplot2 plot object.
}
\description{
The type of frequency plot depends on the number of selected columns:
\itemize{
\item One categorical column: see \link{plot_counts_one}
\item Multiple categorical columns: see \link{plot_counts_items}
}

Cross tabulations:
\itemize{
\item One categorical column and one grouping column: see \link{plot_counts_one_grouped}
\item Multiple categorical columns and one grouping column: see \link{plot_counts_items_grouped}
\item Two categorical column selections: see \link{plot_counts_items_grouped_items} (not yet implemented)
}

By default, if you provide two column selections, the second selection is treated as categorical.
Setting the metric-parameter to TRUE will call the appropriate functions for correlation analysis:
\itemize{
\item One categorical column and one metric column: see \link{plot_counts_one_cor}
\item Multiple categorical columns and one metric column: see \link{plot_counts_items_cor}
\item Multiple categorical columns and multiple metric columns: see \link{plot_counts_items_cor_items} (not yet implemented)
}

Parameters that may be passed to the count functions
(see the respective function help):
\itemize{
\item \strong{ci}: Add confidence intervals to proportions.
\item \strong{ordered}: The values of the cross column can be nominal (0), ordered ascending (1), or ordered descending (-1).
The colors are adjusted accordingly.
\item \strong{category}: When you have multiple categories in a column, you can focus one of the categories to simplify the plots.
By default, if a column has only TRUE and FALSE values, the outputs focus the TRUE category.
\item \strong{prop}: For stacked bar charts, displaying row percentages instead of total percentages gives a direct visual comparison of groups.
\item \strong{limits}: The scale limits are automatically guessed by the package functions (work in progress).
Use the limits-parameter to manually fix any misleading graphs.
\item \strong{title}: All plots usually get a title derived from the column attributes or column names.
Set to FALSE to suppress the title or provide a title of your choice as a character value.
\item \strong{labels}: Labels are extracted from the column attributes.
Set to FALSE to output bare column names and values.
\item \strong{numbers}: Set the numbers parameter to “n” (frequency), “p” (percentage) or c(“n”,“p”).
To prevent cluttering and overlaps, numbers are only plotted on bars larger than 5\%.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

plot_counts(data, sd_gender)

}
