% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_metrics_items_cor}
\alias{effect_metrics_items_cor}
\title{Output correlation coefficients for items and one metric variable}
\usage{
effect_metrics_items_cor(
  data,
  cols,
  cross,
  method = "pearson",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{cross}{The column holding metric values to correlate.}

\item{method}{The output metrics, pearson = Pearson's R, spearman = Spearman's rho.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker table containing correlations.
}
\description{
The correlation is calculated using \code{stats::\link[stats:cor.test]{cor.test}}.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_metrics_items_cor(
  data, starts_with("cg_adoption_adv"), sd_age
)

}
\keyword{internal}
