% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_analysis.R
\name{Nadults}
\alias{Nadults}
\title{Calculate the harmonic mean of the total number of adults}
\usage{
Nadults(
  data,
  scenarios = "all",
  npops_noMeta = 1,
  appendMeta = FALSE,
  gen = 1,
  yr0 = 1,
  yrt = 2,
  save2disk = TRUE,
  fname = "Nadults",
  dir_out = "DataAnalysis"
)
}
\arguments{
\item{data}{The second element (census_means) of the output from \code{collate_yr}}

\item{scenarios}{A vector of scenario names for which Ne needs to be
calculated, default: 'all'}

\item{npops_noMeta}{The total number of populations excluding the metapopulation,
default: 1}

\item{appendMeta}{Whether to calculate data for the metapopulation,
default: FALSE}

\item{gen}{The generation time express in years}

\item{yr0}{The time window to be considered (first and last year
respectively)}

\item{yrt}{The time window to be considered (first and last year
respectively)}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{fname}{The name of the files where to save the output, defult: 'Nadults'}

\item{dir_out}{The local path to store the output. Default: DataAnalysis}
}
\value{
A \code{data.table} (\code{data.frame} if \code{\link[data.table]{data.table}} is not
 loaded) with Nb values
}
\description{
\code{Nadults} calculates, for several scenarios, the harmonic mean of the total
number of adults between \code{yr0} and \code{yrt}. These can be use to
calculate Ne/N ratios where relevant.
}
\details{
\code{yrt} is adjusted by subtracting the number of years of the generation
time (rounded to the nearest integer). In this way the user can provide the
same \code{yr0,yrt} and \code{gen} to \code{Nadults} and \code{Ne} and these
values are adjusted internally to correctly calculate the Ne/N ratios where
relevant. If this behaviour is not desired, use \code{gen=0}.
}
\examples{
# Using Pacioni et al. example data. See ?pac.yr for more details.
data(pac.yr)
NadultAll <- Nadults(data=pac.yr[[2]], scenarios='all', gen=2.54, yr0=50,
                     yrt=120, save2disk=FALSE)
}
