% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_analysis.R
\name{pairwise}
\alias{pairwise}
\title{Pairwise comparisons and ranks of scenarios}
\usage{
pairwise(
  data,
  project,
  scenario,
  params = c("PExtinct", "Nextant", "Het", "Nalleles"),
  yrs = "max",
  ST = FALSE,
  type = NA,
  group.mean = FALSE,
  SVs = NA,
  save2disk = TRUE,
  dir_out = "DataAnalysis/Pairwise"
)
}
\arguments{
\item{data}{A data.frame generated by \code{collate_dat}}

\item{project}{The Vortex project name}

\item{scenario}{The ST Vortex scenario name or the scenario that should be
used as baseline if simulations were not conducted with the ST module}

\item{params}{A character vector with the parameters to be compared,
default: c('PExtinct', 'Nextant', 'Het', 'Nalleles')}

\item{yrs}{The year(s) to be analysed, default: 'max'}

\item{ST}{Whether files are from sensitivity analysis (TRUE),
or not (FALSE, default)}

\item{type}{Type of ST. Possible options are: 'Sampled',
'Latin Hypercube Sampling', 'Factorial' or 'Single-Factor'}

\item{group.mean}{Whether calculate the mean of the statistics
(SSMD and Sensitivity Coefficient) by group. See details}

\item{SVs}{A character vector with the parameters to be used to group
scenarios, default: NA}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: DataAnalysis/Pairwise}
}
\value{
A list of six elements:
\itemize{
  \item A data.frame with SC values for all scenarios
  \item A data.frame with SSMD values
  \item A data.frame with p-values for SSMD values
  \item A data.frame with the scenario ranks based on SC and one based on SSMD
  \item The output of the Kendall's test
}
If \code{group_mean=TRUE} there will be six additional elements:
\itemize{
  \item A data.frame with the mean SC values for each parameter
  \item A data.frame with the mean SSMD values
  \item A data.frame with p-values calculated for the mean SSMD values
  \item A data.frame with the parameter ranks based on the mean SC and one
        based on the mean SSMD
  \item The output of the Kendall's test performed on the ranking of the
        parameters
}
}
\description{
\code{pairwise} conducts pairwise comparisons against a baseline scenario
using sensitivity coefficients and strictly standardised mean difference.
It also ranks scenarios (and/or parameters when relevant) using these statistics.
When \code{yrs='max'} (default), VortexR automatically sets  \code{yrs} to
the last year of the simulation.
}
\details{
Pairwise comparisons against a baseline scenario are conducted using
sensitivity coefficients (SC, Drechsler et al. 1998) and strictly
standardised mean difference (SSDM, Zhang 2007).

\code{pairwise} ranks, for each population, the scenarios (and SVs if
relevant, see below) based on the absolute value of the statistics (either SC
or SSMD) regardless of the sign. That is, the scenario with the absolute SC
or SSMD value most different from zero will have a rank equal to '1'. The
actual statistics need to be inspected to evaluate the direction of the change.

The Kendall's coefficient of concordance is calculated to test whether the
order of ranked scenarios (or SVs if relevant) is statistically consistent
across the chosen points in time and parameters (or SVs). For example, if 100
years were simulated, \code{yrs=c(50, 100)} and \code{params=c('Nall', 'Het')},
the consistency of ranking will be tested across the four raters (i.e. Nall
at year 50, and at year 100, Het at year 50 and at year 100). Kendall's test
operates a listwise deletion of missing data. However, when data in a whole
column (i.e. ranks for a parameter) are missing, the column is removed before
the statistic is calculated (See vignette for more information).

It is possible to evaluate the mean effect of a range of values for certain
parameters on their outcome variables of interest (i.e. ranking the parameters,
rather than scenarios). This is automatically done when the analysis is
conducted on with \code{ST=TRUE,type='Single-Factor'} and there is more than
one SV passed with the argument \code{SVs}. Alternatively, it is achievable
with a combined use of \code{group.mean=TRUE,SVs}. The first argument result
in the calculations, following Conroy and Brook (2003), of the mean SC and
SSMD for each group of scenarios that have different parameter values. \code{SVs}
provides the names of the parameters to be considered. Parameters are then
ranked accordingly (See vignette for more information).

The parameter values passed with \code{SVs} are evaluated at year=0. This is
done because these parameters may take value 'zero' if the relevant
populations goes extinct. There are cases where Vortex may not evaluate these
parameters even at year 0. This may happen, for example, when a population is
empty at initialization (i.e. the initial population size is zero), or when K
is set to zero at the beginning of the simulation. The user has to make sure
that the values for the parameters passed in are correct.

Note that it only makes sense to rank parameters in a ST run when the
Single-Factor option is used in Vortex. This is because with Single-Factor,
the parameters are modified one at the time (See vignette for more information).
}
\examples{
# Using Pacioni et al. example data. See ?pac.clas for more details.
data(pac.clas)
pairw<-pairwise(data=pac.clas, project='Pacioni_et_al', scenario='ST_Classic',
               params=c('Nall', 'Het'), yrs=c(60,120), ST=TRUE,
               type='Single-Factor',
               SVs=c('SV1', 'SV2', 'SV3', 'SV4', 'SV5', 'SV6', 'SV7'),
               save2disk=FALSE)
}
\references{
Conroy, S. D. S., and B. W. Brook. 2003. Demographic sensitivity and
persistence of the threatened white- and orange-bellied frogs of Western
Australia. Population Ecology 45:105-114.

Drechsler, M., M. A. Burgman, and P. W. Menkhorst. 1998. Uncertainty in
population dynamics and its consequences for the management of the
orange-bellied parrot \emph{Neophema chrysogaster}. Biological Conservation
84:269-281.

Zhang, X. D. 2007. A pair of new statistical parameters for quality control
in RNA interference high-throughput screening assays. Genomics 89:552-561.
}
