% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.actor.youtube.R
\name{Create.actor.youtube}
\alias{Create.actor.youtube}
\title{Create youtube actor network}
\usage{
\method{Create}{actor.youtube}(datasource, type, writeToFile = FALSE,
  ...)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"youtube"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"actor"}.}

\item{writeToFile}{Logical. Save network data to a file in the current working directory. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Named list containing generated network as igraph object \code{$graph}.
}
\description{
Creates a youtube actor network from comment threads on youtube videos. Users who have made comments to 
a video (top-level comments) and users who have replied to those comments are actor nodes. The comments are 
represented as directed edges between the actors. The video id is also included as an actor node, representative of 
the videos publisher with top-level comments as directed edges towards them.
}
\examples{
\dontrun{
# create a youtube actor network graph
actorNetwork <- youtubeData \%>\% Create("actor", writeToFile = TRUE)

# igraph object
# actorNetwork$graph
}

}
