% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate_beta_binomial}
\alias{generate_beta_binomial}
\title{Generate beta-binomial scores}
\usage{
generate_beta_binomial(
  n_voters,
  n_candidates,
  min = 0,
  max = 10,
  alpha = 0.5,
  beta = 0.5
)
}
\arguments{
\item{n_voters}{integer, the number of voters to generate scores for.}

\item{n_candidates}{integer,  The number of candidates to generate scores for.}

\item{min}{The minimum value of the  distribution, by default 0}

\item{max}{The maximum value of the  distribution, by default 10}

\item{alpha}{The first parameter of the beta-binomial distribution, by default 0.5}

\item{beta}{The second parameter of the beta-binomial distribution, by default 0.5}
}
\value{
A matrix of scores with 'n_candidates' rows and 'n_voters' columns.
}
\description{
This function generates  discrete scores following a beta-binomial distribution on a given scale
}
\examples{
voting_situation <- generate_beta_binomial(n_voters=10, n_candidates=3,  max=7)
}
