% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funkmeans.R
\name{funkmeans}
\alias{funkmeans}
\title{Functional k-means clustering for parallel smooths}
\usage{
funkmeans(fdobj, deriv = 1, lambda = 0, ncomp, centers, nstart = 10,
  store.fdobj = TRUE)
}
\arguments{
\item{fdobj}{a functional data object, of class \code{"\link[fda]{fd}"},
defining the set of curves being clustered.}

\item{deriv}{which derivative of the curves should be clustered.  If
\code{0}, the curves themselves are clustered; if \code{1} (the default),
their first derivatives are clustered, a natural way to assign curves of
similar shape to the same cluster.}

\item{lambda}{smoothing parameter for functional PCA as implemented by
\code{\link[fda]{pca.fd}}.}

\item{ncomp}{number of functional principal components.}

\item{centers}{number of clusters.}

\item{nstart}{number of randomly chosen sets of initial centers used by the
\code{\link[stats]{kmeans}} function.}

\item{store.fdobj}{logical: Should the input fd object be stored in the
output? May wish to set to FALSE for large sets of smooths.}
}
\value{
An object of class "funkmeans", which is a list with elements:
\item{cluster, centers, withinss, tots, tot.withinss, betweenness, size}{see
\code{\link[stats]{kmeans}}.} \item{basis,coef}{basis object and coefficient
matrix defining the functional data object (see \code{\link[fda]{fd}}) for
the curves that are clustered.} \item{fpca}{functional principal components
object, output by \code{\link[fda]{pca.fd}}.} \item{R2}{proportion of
variance explained by the k clusters.}
}
\description{
This function performs k-means clustering for curve estimates corresponding
to each of a 3D grid of points. For example, when scatterplot smoothing is
performed at each of a grid of brain voxels as in Reiss et al. (2014), this
function can be used to cluster the obtained smooths.
}
\details{
The functional clustering algorithm consists of performing (i) functional
principal component analysis of the curve estimates or their derivatives,
followed by (ii) k-means clustering of the functional PC scores (Tarpey and
Kinateder, 2003).
}
\examples{

data(test)
d4 = test$d4
x = test$x
semi.obj = semipar4d(d4, ~sf(x), -5:5, data.frame(x = x))
fdobj = extract.fd(semi.obj)
fkmobj = funkmeans4d(fdobj, d4, ncomp=6, centers=3)
}
\author{
Philip Reiss \email{phil.reiss@nyumc.org}, Lei Huang
\email{huangracer@gmail.com} and Lan Huo
}
\references{
Alexander-Bloch, A. F., Reiss, P. T., Rapoport, J., McAdams, H.,
Giedd, J. N., Bullmore, E. T., and Gogtay, N. (2014). Abnormal cortical
growth in schizophrenia targets normative modules of synchronized
development. \emph{Biological Psychiatry}, in press.

Reiss, P. T., Huang, L., Chen, Y.-H., Huo, L., Tarpey, T., and Mennes, M.
(2014). Massively parallel nonparametric regression, with an application to
developmental brain mapping. \emph{Journal of Computational and Graphical
Statistics}, \emph{Journal of Computational and Graphical Statistics},
23(1), 232--248.

Tarpey, T., and Kinateder, K. K. J. (2003).  Clustering functional data.
\emph{Journal of Classification}, 20, 93--114.
}
\seealso{
\code{\link{funkmeans4d}}
}

